/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostalAddressSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(PostalAddressSyntaxChecker.class);

    public PostalAddressSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.41");
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int dollar = strValue.indexOf(36);
        if (dollar == -1) {
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        int pos = 0;
        do {
            String address;
            if (Strings.isEmpty((String)(address = strValue.substring(pos, dollar)))) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            pos = dollar + 1;
            if (pos != strValue.length()) continue;
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        } while ((dollar = strValue.indexOf(36, pos)) > -1);
        return true;
    }
}

