/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.TCCommandAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayPacketsCommandAction
extends TCCommandAction {
    private static final Logger LOG = LoggerFactory.getLogger(DelayPacketsCommandAction.class);
    private final long delay;
    private final long duration;

    public DelayPacketsCommandAction(long delay, long duration, long timeout, String network) {
        super(timeout, network);
        this.delay = delay;
        this.duration = duration;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void localPerform() throws IOException {
        this.getLogger().info("Starting to execute DelayPacketsCommandAction");
        ServerName server = PolicyBasedChaosMonkey.selectRandomItem(this.getCurrentServers());
        String hostname = server.getHostname();
        try {
            this.clusterManager.execSudoWithRetries(hostname, this.timeout, this.getCommand("add"));
            Thread.sleep(this.duration);
        }
        catch (InterruptedException e) {
            try {
                this.getLogger().debug("Failed to run the command for the full duration", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clusterManager.execSudoWithRetries(hostname, this.timeout, this.getCommand("del"));
                throw throwable;
            }
            this.clusterManager.execSudoWithRetries(hostname, this.timeout, this.getCommand("del"));
        }
        this.clusterManager.execSudoWithRetries(hostname, this.timeout, this.getCommand("del"));
        this.getLogger().info("Finished to execute DelayPacketsCommandAction");
    }

    private String getCommand(String operation) {
        return String.format("tc qdisc %s dev %s root netem delay %sms %sms", operation, this.network, this.delay, this.delay / 2L);
    }
}

