/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveRegionsOfTableAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(MoveRegionsOfTableAction.class);
    private final long sleepTime;
    private final TableName tableName;
    private final long maxTime;

    public MoveRegionsOfTableAction(long sleepTime, long maxSleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
        this.maxTime = maxSleepTime;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
        Admin admin = this.context.getHBaseIntegrationTestingUtility().getAdmin();
        ServerName[] servers = MoveRegionsOfTableAction.getServers(admin);
        this.getLogger().info("Performing action: Move regions of table {}", (Object)this.tableName);
        List regions = admin.getRegions(this.tableName);
        if (regions == null || regions.isEmpty()) {
            this.getLogger().info("Table {} doesn't have regions to move", (Object)this.tableName);
            return;
        }
        Collections.shuffle(regions);
        long start = EnvironmentEdgeManager.currentTime();
        for (RegionInfo regionInfo : regions) {
            if (this.context.isStopping()) {
                return;
            }
            MoveRegionsOfTableAction.moveRegion(admin, servers, regionInfo, this.getLogger());
            if (this.sleepTime > 0L) {
                Thread.sleep(this.sleepTime);
            }
            if (EnvironmentEdgeManager.currentTime() - start <= this.maxTime) continue;
            break;
        }
    }

    static ServerName[] getServers(Admin admin) throws IOException {
        Collection serversList = admin.getRegionServers();
        return serversList.toArray(new ServerName[0]);
    }

    static void moveRegion(Admin admin, ServerName[] servers, RegionInfo regionInfo, Logger logger) {
        try {
            ServerName destServerName = servers[ThreadLocalRandom.current().nextInt(servers.length)];
            logger.debug("Moving {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)destServerName);
            admin.move(regionInfo.getEncodedNameAsBytes(), destServerName);
        }
        catch (Exception ex) {
            logger.warn("Move failed, might be caused by other chaos: {}", (Object)ex.getMessage());
        }
    }
}

