/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.test.util.CRC64;
import org.apache.hadoop.hbase.test.util.warc.WARCInputFormat;
import org.apache.hadoop.hbase.test.util.warc.WARCRecord;
import org.apache.hadoop.hbase.test.util.warc.WARCWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationTestLoadCommonCrawl
extends IntegrationTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestLoadCommonCrawl.class);
    static final String TABLE_NAME_KEY = "IntegrationTestLoadCommonCrawl.table";
    static final String DEFAULT_TABLE_NAME = "IntegrationTestLoadCommonCrawl";
    static final String INCREMENTS_NAME_KEY = "IntegrationTestLoadCommonCrawl.increments";
    static final boolean DEFAULT_INCREMENTS = false;
    static final int MAX_INFLIGHT = 1000;
    static final int INFLIGHT_PAUSE_MS = 100;
    static final byte[] CONTENT_FAMILY_NAME = Bytes.toBytes((String)"c");
    static final byte[] INFO_FAMILY_NAME = Bytes.toBytes((String)"i");
    static final byte[] URL_FAMILY_NAME = Bytes.toBytes((String)"u");
    static final byte[] SEP = Bytes.toBytes((String)":");
    static final byte[] CONTENT_QUALIFIER = HConstants.EMPTY_BYTE_ARRAY;
    static final byte[] CONTENT_LENGTH_QUALIFIER = Bytes.toBytes((String)"l");
    static final byte[] CONTENT_TYPE_QUALIFIER = Bytes.toBytes((String)"t");
    static final byte[] CRC_QUALIFIER = Bytes.toBytes((String)"c");
    static final byte[] DATE_QUALIFIER = Bytes.toBytes((String)"d");
    static final byte[] IP_ADDRESS_QUALIFIER = Bytes.toBytes((String)"a");
    static final byte[] TARGET_URI_QUALIFIER = Bytes.toBytes((String)"u");
    static final byte[] REF_QUALIFIER = Bytes.toBytes((String)"ref");
    protected Path warcFileInputDir = null;
    protected Path outputDir = null;
    protected String[] args;
    private static final AtomicLong counter = new AtomicLong();
    private static final int shift = 8;
    static final Pattern URL_PATTERN = Pattern.compile("\\b((https?|ftp|file)://|(www|ftp)\\.)[\\-A-Z0-9+&@#/%?=~_|$!:,\\.;]*[A-Z0-9+&@#/%=~_|$]", 2);

    protected int runLoader(Path warcFileInputDir, Path outputDir) throws Exception {
        Loader loader = new Loader();
        loader.setConf(this.conf);
        return loader.run(warcFileInputDir, outputDir);
    }

    protected int runVerify(Path inputDir) throws Exception {
        Verify verify = new Verify();
        verify.setConf(this.conf);
        return verify.run(inputDir);
    }

    public int run(String[] args) {
        if (args.length > 0) {
            this.warcFileInputDir = new Path(args[0]);
            if (args.length > 1) {
                this.outputDir = new Path(args[1]);
            }
        }
        try {
            if (this.warcFileInputDir == null) {
                throw new IllegalArgumentException("WARC input file or directory not specified");
            }
            if (this.outputDir == null) {
                throw new IllegalArgumentException("Output directory not specified");
            }
            int res = this.runLoader(this.warcFileInputDir, this.outputDir);
            if (res != 0) {
                LOG.error("Loader failed");
                return -1;
            }
            return this.runVerify(this.outputDir);
        }
        catch (Exception e) {
            LOG.error("Tool failed with exception", (Throwable)e);
            return -1;
        }
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        this.processBaseOptions(cmd);
        this.args = cmd.getArgs();
    }

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        boolean isDistributed = this.util.isDistributedCluster();
        this.util.initializeCluster(isDistributed ? 1 : 3);
        if (!isDistributed) {
            this.util.startMiniMapReduceCluster();
        }
        this.setConf(this.util.getConfiguration());
    }

    @Override
    public void cleanUpCluster() throws Exception {
        super.cleanUpCluster();
        if (this.util.isDistributedCluster()) {
            this.util.shutdownMiniMapReduceCluster();
        }
    }

    static TableName getTablename(Configuration c) {
        return TableName.valueOf((String)c.get(TABLE_NAME_KEY, DEFAULT_TABLE_NAME));
    }

    @Override
    public TableName getTablename() {
        return IntegrationTestLoadCommonCrawl.getTablename(this.getConf());
    }

    @Override
    protected Set<String> getColumnFamilies() {
        HashSet<String> families = new HashSet<String>();
        families.add(Bytes.toString((byte[])CONTENT_FAMILY_NAME));
        families.add(Bytes.toString((byte[])INFO_FAMILY_NAME));
        families.add(Bytes.toString((byte[])URL_FAMILY_NAME));
        return families;
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        return ToolRunner.run((Configuration)this.getConf(), (Tool)this, (String[])this.args);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestLoadCommonCrawl(), (String[])args);
        System.exit(ret);
    }

    private static long getSequence() {
        long t = EnvironmentEdgeManager.currentTime();
        t <<= 8;
        return t |= counter.getAndIncrement() % 256L;
    }

    private static byte[] rowKeyFromTargetURI(String targetUri) throws IOException, URISyntaxException, IllegalArgumentException {
        StringBuilder sb;
        URI uri = new URI(targetUri);
        if (uri.getHost() != null) {
            String[] hostComponents = (String[])Splitter.on((char)'.').splitToStream((CharSequence)uri.getHost()).toArray(String[]::new);
            sb = new StringBuilder();
            for (int i = hostComponents.length - 1; i >= 0; --i) {
                sb.append(hostComponents[i]);
                if (i == 0) continue;
                sb.append('.');
            }
        } else {
            throw new IllegalArgumentException("URI is missing host component");
        }
        String reversedHost = sb.toString();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(reversedHost.getBytes(StandardCharsets.UTF_8));
        if (uri.getPort() >= 0) {
            os.write(String.format(":%d", uri.getPort()).getBytes(StandardCharsets.UTF_8));
        }
        os.write(124);
        if (uri.getPath() != null) {
            os.write(uri.getPath().getBytes(StandardCharsets.UTF_8));
        }
        if (uri.getQuery() != null) {
            os.write(String.format("?%s", uri.getQuery()).getBytes(StandardCharsets.UTF_8));
        }
        if (uri.getFragment() != null) {
            os.write(String.format("#%s", uri.getFragment()).getBytes(StandardCharsets.UTF_8));
        }
        if (os.size() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Key would be too large (length=" + os.size() + ", limit=" + Short.MAX_VALUE);
        }
        return os.toByteArray();
    }

    private static Collection<String> extractUrls(byte[] content) {
        HashSet<String> list = new HashSet<String>();
        Matcher m = URL_PATTERN.matcher(new String(content, StandardCharsets.UTF_8));
        while (m.find()) {
            list.add(m.group());
        }
        return list;
    }

    public static class Verify
    extends Configured
    implements Tool {
        public static final Logger LOG = LoggerFactory.getLogger(Verify.class);
        public static final String USAGE = "Verify <inputDir>";

        int run(Path inputDir) throws IOException, ClassNotFoundException, InterruptedException {
            Job job = Job.getInstance((Configuration)this.getConf());
            job.setJobName(Verify.class.getName());
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setMapperClass(VerifyMapper.class);
            job.setInputFormatClass(OneFilePerMapperSFIF.class);
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
            job.setOutputFormatClass(NullOutputFormat.class);
            job.setOutputKeyClass(NullWritable.class);
            job.setOutputValueClass(NullWritable.class);
            TableMapReduceUtil.addDependencyJars((Job)job);
            boolean success = job.waitForCompletion(true);
            if (!success) {
                LOG.error("Failure during job " + job.getJobID());
            }
            Counters counters = job.getCounters();
            for (Counts c : Counts.values()) {
                long value = counters.findCounter((Enum)c).getValue();
                if (value == 0L) continue;
                LOG.info((Object)((Object)c) + ": " + value);
            }
            if (counters.findCounter((Enum)Counts.UNREFERENCED).getValue() > 0L) {
                LOG.error("Nonzero UNREFERENCED count from job " + job.getJobID());
                success = false;
            }
            if (counters.findCounter((Enum)Counts.CORRUPT).getValue() > 0L) {
                LOG.error("Nonzero CORRUPT count from job " + job.getJobID());
                success = false;
            }
            return success ? 0 : 1;
        }

        public int run(String[] args) throws Exception {
            if (args.length < 2) {
                System.err.println(USAGE);
                return 1;
            }
            Path loaderOutput = new Path(args[0]);
            return this.run(loaderOutput);
        }

        public static void main(String[] args) throws Exception {
            System.exit(ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new Verify(), (String[])args));
        }

        public static class VerifyMapper
        extends Mapper<HBaseKeyWritable, BytesWritable, NullWritable, NullWritable> {
            protected Connection conn;
            protected Table table;

            protected void setup(Mapper.Context context) throws IOException, InterruptedException {
                Configuration conf = context.getConfiguration();
                this.conn = ConnectionFactory.createConnection((Configuration)conf);
                this.table = this.conn.getTable(IntegrationTestLoadCommonCrawl.getTablename(conf));
            }

            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                try {
                    this.table.close();
                }
                catch (Exception e) {
                    LOG.warn("Exception closing table", (Throwable)e);
                }
                try {
                    this.conn.close();
                }
                catch (Exception e) {
                    LOG.warn("Exception closing Connection", (Throwable)e);
                }
            }

            protected void map(HBaseKeyWritable key, BytesWritable value, Mapper.Context output) throws IOException, InterruptedException {
                byte[] row = Bytes.copy((byte[])key.getRowArray(), (int)key.getRowOffset(), (int)key.getRowLength());
                byte[] family = Bytes.copy((byte[])key.getFamilyArray(), (int)key.getFamilyOffset(), (int)key.getFamilyLength());
                byte[] qualifier = Bytes.copy((byte[])key.getQualifierArray(), (int)key.getQualifierOffset(), (int)key.getQualifierLength());
                long ts = key.getTimestamp();
                if (Bytes.equals((byte[])INFO_FAMILY_NAME, (byte[])family) && Bytes.equals((byte[])CRC_QUALIFIER, (byte[])qualifier)) {
                    Result r;
                    long expectedCRC64 = Bytes.toLong((byte[])value.getBytes(), (int)0, (int)value.getLength());
                    Get get = new Get(row).setTimestamp(ts).addFamily(CONTENT_FAMILY_NAME).addFamily(INFO_FAMILY_NAME);
                    long startTime = System.currentTimeMillis();
                    try {
                        r = this.table.get(get);
                        output.getCounter((Enum)Counts.RPC_TIME_MS).increment(System.currentTimeMillis() - startTime);
                    }
                    catch (Exception e) {
                        LOG.error("Row " + Bytes.toStringBinary((byte[])row) + ": exception", (Throwable)e);
                        output.getCounter((Enum)Counts.UNREFERENCED).increment(1L);
                        return;
                    }
                    byte[] crcBytes = r.getValue(INFO_FAMILY_NAME, CRC_QUALIFIER);
                    if (crcBytes == null) {
                        LOG.error("Row " + Bytes.toStringBinary((byte[])row) + ": missing i:c");
                        output.getCounter((Enum)Counts.UNREFERENCED).increment(1L);
                        return;
                    }
                    if (Bytes.toLong((byte[])crcBytes) != expectedCRC64) {
                        LOG.error("Row " + Bytes.toStringBinary((byte[])row) + ": i:c mismatch");
                        output.getCounter((Enum)Counts.CORRUPT).increment(1L);
                        return;
                    }
                    output.getCounter((Enum)Counts.REFERENCED).increment(1L);
                    byte[] content = r.getValue(CONTENT_FAMILY_NAME, CONTENT_QUALIFIER);
                    if (content == null) {
                        LOG.error("Row " + Bytes.toStringBinary((byte[])row) + ": missing content");
                        output.getCounter((Enum)Counts.UNREFERENCED).increment(1L);
                        return;
                    }
                    CRC64 crc = new CRC64();
                    crc.update(content);
                    if (crc.getValue() != expectedCRC64) {
                        LOG.error("Row " + Bytes.toStringBinary((byte[])row) + ": corrupt content");
                        output.getCounter((Enum)Counts.CORRUPT).increment(1L);
                        return;
                    }
                    output.getCounter((Enum)Counts.REFERENCED).increment(1L);
                } else {
                    Result r;
                    long startTime = System.currentTimeMillis();
                    Get get = new Get(row).setTimestamp(ts).addColumn(family, qualifier);
                    try {
                        r = this.table.get(get);
                        output.getCounter((Enum)Counts.RPC_TIME_MS).increment(System.currentTimeMillis() - startTime);
                    }
                    catch (Exception e) {
                        LOG.error("Row " + Bytes.toStringBinary((byte[])row) + ": exception", (Throwable)e);
                        output.getCounter((Enum)Counts.UNREFERENCED).increment(1L);
                        return;
                    }
                    byte[] bytes = r.getValue(family, qualifier);
                    if (bytes == null) {
                        LOG.error("Row " + Bytes.toStringBinary((byte[])row) + ": missing " + Bytes.toStringBinary((byte[])family) + ":" + Bytes.toStringBinary((byte[])qualifier));
                        output.getCounter((Enum)Counts.UNREFERENCED).increment(1L);
                        return;
                    }
                    if (!Bytes.equals((byte[])bytes, (int)0, (int)bytes.length, (byte[])value.getBytes(), (int)0, (int)value.getLength())) {
                        LOG.error("Row " + Bytes.toStringBinary((byte[])row) + ": " + Bytes.toStringBinary((byte[])family) + ":" + Bytes.toStringBinary((byte[])qualifier) + " mismatch");
                        output.getCounter((Enum)Counts.CORRUPT).increment(1L);
                        return;
                    }
                    output.getCounter((Enum)Counts.REFERENCED).increment(1L);
                }
            }
        }
    }

    public static class OneFilePerMapperSFIF<K, V>
    extends SequenceFileInputFormat<K, V> {
        protected boolean isSplitable(JobContext context, Path filename) {
            return false;
        }
    }

    public static class Loader
    extends Configured
    implements Tool {
        private static final Logger LOG = LoggerFactory.getLogger(Loader.class);
        private static final String USAGE = "Loader <warInputDir | warFileList> <outputDir>";

        void createSchema(TableName tableName) throws IOException {
            try (Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());
                 Admin admin = conn.getAdmin();){
                if (!admin.tableExists(tableName)) {
                    ColumnFamilyDescriptorBuilder contentFamilyBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])CONTENT_FAMILY_NAME).setMaxVersions(1000).setDataBlockEncoding(DataBlockEncoding.NONE).setBloomFilterType(BloomType.ROW);
                    ColumnFamilyDescriptorBuilder infoFamilyBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])INFO_FAMILY_NAME).setMaxVersions(1000).setDataBlockEncoding(DataBlockEncoding.ROW_INDEX_V1).setBloomFilterType(BloomType.ROWCOL).setBlocksize(8192);
                    ColumnFamilyDescriptorBuilder urlFamilyBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])URL_FAMILY_NAME).setMaxVersions(1000).setDataBlockEncoding(DataBlockEncoding.ROW_INDEX_V1).setBloomFilterType(BloomType.ROWCOL).setBlocksize(8192);
                    HashSet<ColumnFamilyDescriptor> families = new HashSet<ColumnFamilyDescriptor>();
                    families.add(contentFamilyBuilder.build());
                    families.add(infoFamilyBuilder.build());
                    families.add(urlFamilyBuilder.build());
                    TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamilies(families).build();
                    if (this.getConf().getBoolean("hbase.test.pre-split-table", true)) {
                        int numberOfServers = admin.getRegionServers().size();
                        if (numberOfServers == 0) {
                            throw new IllegalStateException("No live regionservers");
                        }
                        int regionsPerServer = this.getConf().getInt("hbase.test.regions-per-server", 3);
                        int totalNumberOfRegions = numberOfServers * regionsPerServer;
                        LOG.info("Creating test table: " + tableDescriptor);
                        LOG.info("Number of live regionservers: " + numberOfServers + ", pre-splitting table into " + totalNumberOfRegions + " regions (default regions per server: " + regionsPerServer + ")");
                        byte[][] splits = new RegionSplitter.UniformSplit().split(totalNumberOfRegions);
                        admin.createTable(tableDescriptor, splits);
                    } else {
                        LOG.info("Creating test table: " + tableDescriptor);
                        admin.createTable(tableDescriptor);
                    }
                }
            }
            catch (MasterNotRunningException e) {
                LOG.error("Master not running", (Throwable)e);
                throw new IOException(e);
            }
        }

        int run(Path warcFileInput, Path outputDir) throws IOException, ClassNotFoundException, InterruptedException {
            this.createSchema(IntegrationTestLoadCommonCrawl.getTablename(this.getConf()));
            Job job = Job.getInstance((Configuration)this.getConf());
            job.setJobName(Loader.class.getName());
            job.setNumReduceTasks(0);
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setMapperClass(LoaderMapper.class);
            job.setInputFormatClass(WARCInputFormat.class);
            FileSystem fs = FileSystem.get((URI)warcFileInput.toUri(), (Configuration)this.getConf());
            if (fs.getFileStatus(warcFileInput).isDirectory()) {
                LOG.info("Using directory as WARC input path: " + warcFileInput);
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{warcFileInput});
            } else if (warcFileInput.toUri().getScheme().equals("file")) {
                LOG.info("Getting WARC input paths from file: " + warcFileInput);
                ArrayList<Path> paths = new ArrayList<Path>();
                Counts[] countsArray = null;
                try (FSDataInputStream is = fs.open(warcFileInput);){
                    InputStreamReader reader = warcFileInput.getName().toLowerCase().endsWith(".gz") ? new InputStreamReader((InputStream)new GZIPInputStream((InputStream)is), StandardCharsets.UTF_8) : new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
                    try (BufferedReader br = new BufferedReader(reader);){
                        String line;
                        while ((line = br.readLine()) != null) {
                            paths.add(new Path(line));
                        }
                    }
                }
                catch (Throwable object) {
                    countsArray = object;
                    throw object;
                }
                LOG.info("Read " + paths.size() + " WARC input paths from " + warcFileInput);
                FileInputFormat.setInputPaths((Job)job, (Path[])paths.toArray(new Path[paths.size()]));
            } else {
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{warcFileInput});
            }
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
            SequenceFileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
            SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
            job.setOutputKeyClass(HBaseKeyWritable.class);
            job.setOutputValueClass(BytesWritable.class);
            TableMapReduceUtil.addDependencyJars((Job)job);
            job.getConfiguration().setInt("mapred.map.max.attempts", 100);
            job.getConfiguration().setInt("mapreduce.map.maxattempts", 100);
            boolean success = job.waitForCompletion(true);
            if (!success) {
                LOG.error("Failure during job " + job.getJobID());
            }
            Counters counters = job.getCounters();
            for (Counts c : Counts.values()) {
                long value = counters.findCounter((Enum)c).getValue();
                if (value == 0L) continue;
                LOG.info((Object)((Object)c) + ": " + value);
            }
            return success ? 0 : 1;
        }

        public int run(String[] args) throws Exception {
            if (args.length < 2) {
                System.err.println(USAGE);
                return 1;
            }
            try {
                Path warcFileInput = new Path(args[0]);
                Path outputDir = new Path(args[1]);
                return this.run(warcFileInput, outputDir);
            }
            catch (NumberFormatException e) {
                System.err.println("Parsing loader arguments failed: " + e.getMessage());
                System.err.println(USAGE);
                return 1;
            }
        }

        public static void main(String[] args) throws Exception {
            System.exit(ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new Loader(), (String[])args));
        }

        public static class LoaderMapper
        extends Mapper<LongWritable, WARCWritable, HBaseKeyWritable, BytesWritable> {
            protected AsyncConnection conn;
            protected AsyncTable<ScanResultConsumer> table;
            protected ExecutorService executor;
            protected AtomicLong inflight = new AtomicLong();
            protected boolean doIncrements;

            protected void setup(Mapper.Context context) throws IOException, InterruptedException {
                this.executor = Executors.newWorkStealingPool(Runtime.getRuntime().availableProcessors());
                Configuration conf = context.getConfiguration();
                this.doIncrements = conf.getBoolean(IntegrationTestLoadCommonCrawl.INCREMENTS_NAME_KEY, false);
                try {
                    this.conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)conf).get();
                    this.table = this.conn.getTable(IntegrationTestLoadCommonCrawl.getTablename(conf), this.executor);
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
            }

            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                while (this.inflight.get() != 0L) {
                    LOG.info("Operations in flight, waiting");
                    Thread.sleep(100L);
                }
                this.executor.shutdown();
                if (!this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                    LOG.warn("Pool did not shut down cleanly");
                }
                try {
                    this.conn.close();
                }
                catch (Exception e) {
                    LOG.warn("Exception closing Connection", (Throwable)e);
                }
            }

            protected void map(LongWritable key, WARCWritable value, Mapper.Context output) throws IOException, InterruptedException {
                String contentType;
                WARCRecord.Header warcHeader = value.getRecord().getHeader();
                String recordID = warcHeader.getRecordID();
                String targetURI = warcHeader.getTargetURI();
                if (warcHeader.getRecordType().equals("response") && targetURI != null && (contentType = warcHeader.getField("WARC-Identified-Payload-Type")) != null) {
                    byte[] rowKey;
                    try {
                        rowKey = IntegrationTestLoadCommonCrawl.rowKeyFromTargetURI(targetURI);
                    }
                    catch (IllegalArgumentException e2) {
                        LOG.debug("Could not make a row key for record " + recordID + ", ignoring", (Throwable)e2);
                        return;
                    }
                    catch (URISyntaxException e3) {
                        LOG.warn("Could not parse URI \"" + targetURI + "\" for record " + recordID + ", ignoring");
                        return;
                    }
                    byte[] content = value.getRecord().getContent();
                    CRC64 crc = new CRC64();
                    crc.update(content);
                    long crc64 = crc.getValue();
                    LOG.info("{}: content {} bytes, crc64={}", new Object[]{targetURI, content.length, Bytes.toHex((byte[])Bytes.toBytes((long)crc64))});
                    long ts = IntegrationTestLoadCommonCrawl.getSequence();
                    Put put = new Put(rowKey);
                    put.addColumn(CONTENT_FAMILY_NAME, CONTENT_QUALIFIER, ts, content);
                    put.addColumn(INFO_FAMILY_NAME, CONTENT_LENGTH_QUALIFIER, ts, Bytes.toBytes((int)content.length));
                    put.addColumn(INFO_FAMILY_NAME, CONTENT_TYPE_QUALIFIER, ts, Bytes.toBytes((String)contentType));
                    put.addColumn(INFO_FAMILY_NAME, CRC_QUALIFIER, ts, Bytes.toBytes((long)crc64));
                    put.addColumn(INFO_FAMILY_NAME, TARGET_URI_QUALIFIER, ts, Bytes.toBytes((String)targetURI));
                    put.addColumn(INFO_FAMILY_NAME, DATE_QUALIFIER, ts, Bytes.toBytes((String)warcHeader.getDateString()));
                    String ipAddr = warcHeader.getField("WARC-IP-Address");
                    if (ipAddr != null) {
                        put.addColumn(INFO_FAMILY_NAME, IP_ADDRESS_QUALIFIER, ts, Bytes.toBytes((String)ipAddr));
                    }
                    long pending = this.inflight.incrementAndGet();
                    while (pending > 1000L) {
                        LOG.info("Too many operations in flight, waiting");
                        Thread.sleep(100L);
                        pending = this.inflight.get();
                    }
                    long putStartTime = System.currentTimeMillis();
                    CompletableFuture putFuture = this.table.put(put);
                    FutureUtils.addListener((CompletableFuture)putFuture, (r, e) -> {
                        this.inflight.decrementAndGet();
                        if (e == null) {
                            output.getCounter((Enum)Counts.RPC_TIME_MS).increment(System.currentTimeMillis() - putStartTime);
                            output.getCounter((Enum)Counts.RPC_BYTES_WRITTEN).increment(put.heapSize());
                        }
                    });
                    output.write((Object)new HBaseKeyWritable(rowKey, INFO_FAMILY_NAME, CONTENT_LENGTH_QUALIFIER, ts), (Object)new BytesWritable(Bytes.toBytes((int)content.length)));
                    output.write((Object)new HBaseKeyWritable(rowKey, INFO_FAMILY_NAME, CONTENT_TYPE_QUALIFIER, ts), (Object)new BytesWritable(Bytes.toBytes((String)contentType)));
                    output.write((Object)new HBaseKeyWritable(rowKey, INFO_FAMILY_NAME, CRC_QUALIFIER, ts), (Object)new BytesWritable(Bytes.toBytes((long)crc64)));
                    output.write((Object)new HBaseKeyWritable(rowKey, INFO_FAMILY_NAME, TARGET_URI_QUALIFIER, ts), (Object)new BytesWritable(Bytes.toBytes((String)targetURI)));
                    output.write((Object)new HBaseKeyWritable(rowKey, INFO_FAMILY_NAME, DATE_QUALIFIER, ts), (Object)new BytesWritable(Bytes.toBytes((String)warcHeader.getDateString())));
                    if (ipAddr != null) {
                        output.write((Object)new HBaseKeyWritable(rowKey, INFO_FAMILY_NAME, IP_ADDRESS_QUALIFIER, ts), (Object)new BytesWritable(Bytes.toBytes((String)ipAddr)));
                    }
                    if (this.doIncrements) {
                        byte[] refQual = Bytes.add((byte[])REF_QUALIFIER, (byte[])SEP, (byte[])rowKey);
                        for (String refUri : IntegrationTestLoadCommonCrawl.extractUrls(content)) {
                            try {
                                byte[] urlRowKey = IntegrationTestLoadCommonCrawl.rowKeyFromTargetURI(refUri);
                                LOG.debug("  -> {}", (Object)refUri);
                                Increment increment = new Increment(urlRowKey);
                                increment.setTimestamp(ts);
                                increment.addColumn(URL_FAMILY_NAME, refQual, 1L);
                                pending = this.inflight.incrementAndGet();
                                while (pending > 1000L) {
                                    LOG.info("Too many operations in flight, waiting");
                                    Thread.sleep(100L);
                                    pending = this.inflight.get();
                                }
                                long incrStartTime = System.currentTimeMillis();
                                CompletableFuture incrFuture = this.table.increment(increment);
                                FutureUtils.addListener((CompletableFuture)incrFuture, (r, e) -> {
                                    this.inflight.decrementAndGet();
                                    if (e == null) {
                                        output.getCounter((Enum)Counts.RPC_TIME_MS).increment(System.currentTimeMillis() - incrStartTime);
                                        output.getCounter((Enum)Counts.RPC_BYTES_WRITTEN).increment(increment.heapSize());
                                    }
                                });
                            }
                            catch (IllegalArgumentException | URISyntaxException e4) {
                                LOG.debug("Could not make a row key for URI " + refUri + ", ignoring", (Throwable)e4);
                            }
                        }
                    }
                }
            }
        }
    }

    public static class HBaseKeyWritable
    implements Writable {
        private byte[] row;
        private int rowOffset;
        private int rowLength;
        private byte[] family;
        private int familyOffset;
        private int familyLength;
        private byte[] qualifier;
        private int qualifierOffset;
        private int qualifierLength;
        private long ts;

        public HBaseKeyWritable() {
        }

        public HBaseKeyWritable(byte[] row, int rowOffset, int rowLength, byte[] family, int familyOffset, int familyLength, byte[] qualifier, int qualifierOffset, int qualifierLength, long ts) {
            this.row = row;
            this.rowOffset = rowOffset;
            this.rowLength = rowLength;
            this.family = family;
            this.familyOffset = familyOffset;
            this.familyLength = familyLength;
            this.qualifier = qualifier;
            this.qualifierOffset = qualifierOffset;
            this.qualifierLength = qualifierLength;
            this.ts = ts;
        }

        public HBaseKeyWritable(byte[] row, byte[] family, byte[] qualifier, long ts) {
            this(row, 0, row.length, family, 0, family.length, qualifier, 0, qualifier != null ? qualifier.length : 0, ts);
        }

        public HBaseKeyWritable(byte[] row, byte[] family, byte[] qualifier) {
            this(row, family, qualifier, Long.MAX_VALUE);
        }

        public HBaseKeyWritable(byte[] row, byte[] family, long ts) {
            this(row, family, HConstants.EMPTY_BYTE_ARRAY, ts);
        }

        public HBaseKeyWritable(byte[] row, byte[] family) {
            this(row, family, Long.MAX_VALUE);
        }

        public HBaseKeyWritable(Cell cell) {
            this(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp());
        }

        public void readFields(DataInput in) throws IOException {
            this.row = Bytes.toBytes((String)in.readUTF());
            this.rowOffset = 0;
            this.rowLength = this.row.length;
            this.family = Bytes.toBytes((String)in.readUTF());
            this.familyOffset = 0;
            this.familyLength = this.family.length;
            this.qualifier = Bytes.toBytes((String)in.readUTF());
            this.qualifierOffset = 0;
            this.qualifierLength = this.qualifier.length;
            this.ts = in.readLong();
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(new String(this.row, this.rowOffset, this.rowLength, StandardCharsets.UTF_8));
            out.writeUTF(new String(this.family, this.familyOffset, this.familyLength, StandardCharsets.UTF_8));
            if (this.qualifier != null) {
                out.writeUTF(new String(this.qualifier, this.qualifierOffset, this.qualifierLength, StandardCharsets.UTF_8));
            } else {
                out.writeUTF("");
            }
            out.writeLong(this.ts);
        }

        public byte[] getRowArray() {
            return this.row;
        }

        public void setRow(byte[] row) {
            this.row = row;
        }

        public int getRowOffset() {
            return this.rowOffset;
        }

        public void setRowOffset(int rowOffset) {
            this.rowOffset = rowOffset;
        }

        public int getRowLength() {
            return this.rowLength;
        }

        public void setRowLength(int rowLength) {
            this.rowLength = rowLength;
        }

        public byte[] getFamilyArray() {
            return this.family;
        }

        public void setFamily(byte[] family) {
            this.family = family;
        }

        public int getFamilyOffset() {
            return this.familyOffset;
        }

        public void setFamilyOffset(int familyOffset) {
            this.familyOffset = familyOffset;
        }

        public int getFamilyLength() {
            return this.familyLength;
        }

        public void setFamilyLength(int familyLength) {
            this.familyLength = familyLength;
        }

        public byte[] getQualifierArray() {
            return this.qualifier;
        }

        public void setQualifier(byte[] qualifier) {
            this.qualifier = qualifier;
        }

        public int getQualifierOffset() {
            return this.qualifierOffset;
        }

        public void setQualifierOffset(int qualifierOffset) {
            this.qualifierOffset = qualifierOffset;
        }

        public int getQualifierLength() {
            return this.qualifierLength;
        }

        public void setQualifierLength(int qualifierLength) {
            this.qualifierLength = qualifierLength;
        }

        public long getTimestamp() {
            return this.ts;
        }

        public void setTimestamp(long ts) {
            this.ts = ts;
        }
    }

    public static enum Counts {
        REFERENCED,
        UNREFERENCED,
        CORRUPT,
        RPC_BYTES_WRITTEN,
        RPC_TIME_MS;

    }
}

