/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.kerberos;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.crypto.encryption.RandomKeyFactory;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDerivationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(KeyDerivationInterceptor.class);
    private static final Logger LOG_KRB = LoggerFactory.getLogger((String)Loggers.KERBEROS_LOG.getName());
    private static final String NAME = "keyDerivationService";
    private AttributeType KRB5_KEY_AT;
    private AttributeType KRB5_PRINCIPAL_NAME_AT;
    private AttributeType KRB5_KEY_VERSION_NUMBER_AT;
    private AttributeType USER_PASSWORD_AT;

    public KeyDerivationInterceptor() {
        super(NAME);
    }

    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.KRB5_KEY_AT = this.schemaManager.lookupAttributeTypeRegistry("krb5Key");
        this.KRB5_PRINCIPAL_NAME_AT = this.schemaManager.lookupAttributeTypeRegistry("krb5PrincipalName");
        this.KRB5_KEY_VERSION_NUMBER_AT = this.schemaManager.lookupAttributeTypeRegistry("krb5KeyVersionNumber");
        this.USER_PASSWORD_AT = this.schemaManager.lookupAttributeTypeRegistry("userPassword");
        LOG_KRB.info("KeyDerivation Interceptor initialized");
    }

    public void add(AddOperationContext addContext) throws LdapException {
        if (addContext.isReplEvent()) {
            this.next(addContext);
            return;
        }
        Dn normName = addContext.getDn();
        Entry entry = addContext.getEntry();
        if (entry.get(this.USER_PASSWORD_AT) != null && entry.get(this.KRB5_PRINCIPAL_NAME_AT) != null) {
            LOG.debug("Adding the entry '{}' for Dn '{}'.", (Object)entry, (Object)normName.getName());
            BinaryValue userPassword = (BinaryValue)entry.get(this.USER_PASSWORD_AT).get();
            String strUserPassword = userPassword.getString();
            if (LOG.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("'" + strUserPassword + "' ( ");
                sb.append(userPassword);
                sb.append(" )");
                LOG.debug("Adding Attribute id : 'userPassword',  Values : [ {} ]", (Object)sb.toString());
            }
            String principalName = entry.get(this.KRB5_PRINCIPAL_NAME_AT).getString();
            LOG.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)strUserPassword);
            LOG_KRB.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)strUserPassword);
            Map<EncryptionType, EncryptionKey> keys = this.generateKeys(principalName, strUserPassword);
            entry.put(this.KRB5_KEY_VERSION_NUMBER_AT, new String[]{"0"});
            Attribute keyAttribute = this.getKeyAttribute(keys);
            entry.put(new Attribute[]{keyAttribute});
            LOG.debug("Adding modified entry '{}' for Dn '{}'.", (Object)entry, (Object)normName.getName());
            LOG_KRB.debug("Adding modified entry '{}' for Dn '{}'.", (Object)entry, (Object)normName.getName());
        }
        this.next(addContext);
    }

    public void modify(ModifyOperationContext modContext) throws LdapException {
        if (modContext.isReplEvent()) {
            this.next(modContext);
            return;
        }
        ModifySubContext subContext = new ModifySubContext();
        this.detectPasswordModification(modContext, subContext);
        if (subContext.getUserPassword() != null) {
            this.lookupPrincipalAttributes(modContext, subContext);
        }
        if (subContext.isPrincipal() && subContext.hasValues()) {
            this.deriveKeys(modContext, subContext);
        }
        this.next(modContext);
    }

    private void detectPasswordModification(ModifyOperationContext modContext, ModifySubContext subContext) throws LdapException {
        List mods = modContext.getModItems();
        String operation = null;
        for (Modification mod : mods) {
            Attribute attr;
            if (LOG.isDebugEnabled()) {
                switch (mod.getOperation()) {
                    case ADD_ATTRIBUTE: {
                        operation = "Adding";
                        break;
                    }
                    case REMOVE_ATTRIBUTE: {
                        operation = "Removing";
                        break;
                    }
                    case REPLACE_ATTRIBUTE: {
                        operation = "Replacing";
                    }
                }
            }
            if (this.USER_PASSWORD_AT.equals((Object)(attr = mod.getAttribute()).getAttributeType())) {
                Value firstValue = attr.get();
                String password = null;
                if (firstValue instanceof StringValue) {
                    password = ((StringValue)firstValue).getString();
                    LOG.debug("{} Attribute id : 'userPassword',  Values : [ '{}' ]", (Object)operation, (Object)password);
                    LOG_KRB.debug("{} Attribute id : 'userPassword',  Values : [ '{}' ]", (Object)operation, (Object)password);
                } else if (firstValue instanceof BinaryValue) {
                    password = ((BinaryValue)firstValue).getString();
                    if (LOG.isDebugEnabled()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("'" + password + "' ( ");
                        sb.append(Strings.dumpBytes((byte[])((BinaryValue)firstValue).getBytes()).trim());
                        sb.append(" )");
                        LOG.debug("{} Attribute id : 'userPassword',  Values : [ {} ]", (Object)operation, (Object)sb.toString());
                        LOG_KRB.debug("{} Attribute id : 'userPassword',  Values : [ {} ]", (Object)operation, (Object)sb.toString());
                    }
                }
                subContext.setUserPassword(password);
                LOG.debug("Got userPassword '{}'.", (Object)subContext.getUserPassword());
                LOG_KRB.debug("Got userPassword '{}'.", (Object)subContext.getUserPassword());
            }
            if (!this.KRB5_PRINCIPAL_NAME_AT.equals((Object)attr.getAttributeType())) continue;
            subContext.setPrincipalName(attr.getString());
            LOG.debug("Got principal '{}'.", (Object)subContext.getPrincipalName());
            LOG_KRB.debug("Got principal '{}'.", (Object)subContext.getPrincipalName());
        }
    }

    private void lookupPrincipalAttributes(ModifyOperationContext modContext, ModifySubContext subContext) throws LdapException {
        Attribute keyVersionNumberAttr;
        Dn principalDn = modContext.getDn();
        LookupOperationContext lookupContext = modContext.newLookupContext(principalDn, new String[]{"objectClass", "krb5PrincipalName", "krb5KeyVersionNumber"});
        Entry userEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        if (userEntry == null) {
            throw new LdapAuthenticationException(I18n.err((I18n)I18n.ERR_512, (Object[])new Object[]{principalDn}));
        }
        if (!((ClonedServerEntry)userEntry).getOriginalEntry().contains(OBJECT_CLASS_AT, new String[]{"krb5Principal"})) {
            return;
        }
        subContext.isPrincipal(true);
        LOG.debug("Dn {} is a Kerberos principal.  Will attempt key derivation.", (Object)principalDn.getName());
        LOG_KRB.debug("Dn {} is a Kerberos principal.  Will attempt key derivation.", (Object)principalDn.getName());
        if (subContext.getPrincipalName() == null) {
            Attribute principalAttribute = ((ClonedServerEntry)userEntry).getOriginalEntry().get(this.KRB5_PRINCIPAL_NAME_AT);
            String principalName = principalAttribute.getString();
            subContext.setPrincipalName(principalName);
            LOG.debug("Found principal '{}' from lookup.", (Object)principalName);
            LOG_KRB.debug("Found principal '{}' from lookup.", (Object)principalName);
        }
        if ((keyVersionNumberAttr = ((ClonedServerEntry)userEntry).getOriginalEntry().get(this.KRB5_KEY_VERSION_NUMBER_AT)) == null) {
            subContext.setNewKeyVersionNumber(0);
            LOG.debug("Key version number was null, setting to 0.");
            LOG_KRB.debug("Key version number was null, setting to 0.");
        } else {
            int oldKeyVersionNumber = Integer.valueOf(keyVersionNumberAttr.getString());
            int newKeyVersionNumber = oldKeyVersionNumber + 1;
            subContext.setNewKeyVersionNumber(newKeyVersionNumber);
            LOG.debug("Found key version number '{}', setting to '{}'.", (Object)oldKeyVersionNumber, (Object)newKeyVersionNumber);
            LOG_KRB.debug("Found key version number '{}', setting to '{}'.", (Object)oldKeyVersionNumber, (Object)newKeyVersionNumber);
        }
    }

    void deriveKeys(ModifyOperationContext modContext, ModifySubContext subContext) throws LdapException {
        List mods = modContext.getModItems();
        String principalName = subContext.getPrincipalName();
        String userPassword = subContext.getUserPassword();
        int kvno = subContext.getNewKeyVersionNumber();
        LOG.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)userPassword);
        LOG_KRB.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)userPassword);
        Map<EncryptionType, EncryptionKey> keys = this.generateKeys(principalName, userPassword);
        ArrayList<Object> newModsList = new ArrayList<Object>();
        for (Modification mod : mods) {
            newModsList.add(mod);
        }
        DefaultModification krb5PrincipalName = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)new DefaultAttribute(this.KRB5_PRINCIPAL_NAME_AT, new String[]{principalName}));
        newModsList.add(krb5PrincipalName);
        DefaultModification krb5KeyVersionNumber = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)new DefaultAttribute(this.KRB5_KEY_VERSION_NUMBER_AT, new String[]{Integer.toString(kvno)}));
        newModsList.add(krb5KeyVersionNumber);
        Attribute attribute = this.getKeyAttribute(keys);
        newModsList.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute));
        LOG.debug("Added two modifications to the current request : {} and {}", (Object)krb5PrincipalName, (Object)krb5KeyVersionNumber);
        LOG_KRB.debug("Added two modifications to the current request : {} and {}", (Object)krb5PrincipalName, (Object)krb5KeyVersionNumber);
        modContext.setModItems(newModsList);
    }

    private Attribute getKeyAttribute(Map<EncryptionType, EncryptionKey> keys) throws LdapException {
        DefaultAttribute keyAttribute = new DefaultAttribute(this.KRB5_KEY_AT);
        for (EncryptionKey encryptionKey : keys.values()) {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(encryptionKey.computeLength());
                encryptionKey.encode(buffer);
                keyAttribute.add((byte[][])new byte[][]{buffer.array()});
            }
            catch (EncoderException ioe) {
                LOG.error(I18n.err((I18n)I18n.ERR_122, (Object[])new Object[0]), (Throwable)ioe);
                LOG_KRB.error(I18n.err((I18n)I18n.ERR_122, (Object[])new Object[0]), (Throwable)ioe);
            }
        }
        return keyAttribute;
    }

    private Map<EncryptionType, EncryptionKey> generateKeys(String principalName, String userPassword) {
        if (userPassword.equalsIgnoreCase("randomKey")) {
            try {
                return RandomKeyFactory.getRandomKeys();
            }
            catch (KerberosException ke) {
                LOG.debug(ke.getLocalizedMessage(), (Throwable)ke);
                LOG_KRB.debug(ke.getLocalizedMessage(), (Throwable)ke);
                return null;
            }
        }
        return KerberosKeyFactory.getKerberosKeys((String)principalName, (String)userPassword);
    }

    static class ModifySubContext {
        private boolean isPrincipal = false;
        private String principalName;
        private String userPassword;
        private int newKeyVersionNumber = -1;

        ModifySubContext() {
        }

        boolean isPrincipal() {
            return this.isPrincipal;
        }

        void isPrincipal(boolean isPrincipal) {
            this.isPrincipal = isPrincipal;
        }

        String getPrincipalName() {
            return this.principalName;
        }

        void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        String getUserPassword() {
            return this.userPassword;
        }

        void setUserPassword(String userPassword) {
            this.userPassword = userPassword;
        }

        int getNewKeyVersionNumber() {
            return this.newKeyVersionNumber;
        }

        void setNewKeyVersionNumber(int newKeyVersionNumber) {
            this.newKeyVersionNumber = newKeyVersionNumber;
        }

        boolean hasValues() {
            return this.userPassword != null && this.principalName != null && this.newKeyVersionNumber > -1;
        }
    }
}

