/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.client.metrics.ServerSideScanMetrics;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Phoenix"})
@InterfaceStability.Evolving
public final class ThreadLocalServerSideScanMetrics {
    private static final ThreadLocal<Boolean> IS_SCAN_METRICS_ENABLED = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<AtomicLong> BYTES_READ_FROM_FS = ThreadLocal.withInitial(() -> new AtomicLong(0L));
    private static final ThreadLocal<AtomicLong> BYTES_READ_FROM_BLOCK_CACHE = ThreadLocal.withInitial(() -> new AtomicLong(0L));
    private static final ThreadLocal<AtomicLong> BYTES_READ_FROM_MEMSTORE = ThreadLocal.withInitial(() -> new AtomicLong(0L));
    private static final ThreadLocal<AtomicLong> BLOCK_READ_OPS_COUNT = ThreadLocal.withInitial(() -> new AtomicLong(0L));

    private ThreadLocalServerSideScanMetrics() {
    }

    public static void setScanMetricsEnabled(boolean enable) {
        IS_SCAN_METRICS_ENABLED.set(enable);
    }

    public static long addBytesReadFromFs(long bytes) {
        return BYTES_READ_FROM_FS.get().addAndGet(bytes);
    }

    public static long addBytesReadFromBlockCache(long bytes) {
        return BYTES_READ_FROM_BLOCK_CACHE.get().addAndGet(bytes);
    }

    public static long addBytesReadFromMemstore(long bytes) {
        return BYTES_READ_FROM_MEMSTORE.get().addAndGet(bytes);
    }

    public static long addBlockReadOpsCount(long count) {
        return BLOCK_READ_OPS_COUNT.get().addAndGet(count);
    }

    public static boolean isScanMetricsEnabled() {
        return IS_SCAN_METRICS_ENABLED.get();
    }

    public static AtomicLong getBytesReadFromFsCounter() {
        return BYTES_READ_FROM_FS.get();
    }

    public static AtomicLong getBytesReadFromBlockCacheCounter() {
        return BYTES_READ_FROM_BLOCK_CACHE.get();
    }

    public static AtomicLong getBytesReadFromMemstoreCounter() {
        return BYTES_READ_FROM_MEMSTORE.get();
    }

    public static AtomicLong getBlockReadOpsCountCounter() {
        return BLOCK_READ_OPS_COUNT.get();
    }

    public static long getBytesReadFromFsAndReset() {
        return ThreadLocalServerSideScanMetrics.getBytesReadFromFsCounter().getAndSet(0L);
    }

    public static long getBytesReadFromBlockCacheAndReset() {
        return ThreadLocalServerSideScanMetrics.getBytesReadFromBlockCacheCounter().getAndSet(0L);
    }

    public static long getBytesReadFromMemstoreAndReset() {
        return ThreadLocalServerSideScanMetrics.getBytesReadFromMemstoreCounter().getAndSet(0L);
    }

    public static long getBlockReadOpsCountAndReset() {
        return ThreadLocalServerSideScanMetrics.getBlockReadOpsCountCounter().getAndSet(0L);
    }

    public static void reset() {
        ThreadLocalServerSideScanMetrics.getBytesReadFromFsAndReset();
        ThreadLocalServerSideScanMetrics.getBytesReadFromBlockCacheAndReset();
        ThreadLocalServerSideScanMetrics.getBytesReadFromMemstoreAndReset();
        ThreadLocalServerSideScanMetrics.getBlockReadOpsCountAndReset();
    }

    public static void populateServerSideScanMetrics(ServerSideScanMetrics metrics) {
        if (metrics == null) {
            return;
        }
        metrics.addToCounter("BYTES_READ_FROM_FS", ThreadLocalServerSideScanMetrics.getBytesReadFromFsCounter().get());
        metrics.addToCounter("BYTES_READ_FROM_BLOCK_CACHE", ThreadLocalServerSideScanMetrics.getBytesReadFromBlockCacheCounter().get());
        metrics.addToCounter("BYTES_READ_FROM_MEMSTORE", ThreadLocalServerSideScanMetrics.getBytesReadFromMemstoreCounter().get());
        metrics.addToCounter("BLOCK_READ_OPS_COUNT", ThreadLocalServerSideScanMetrics.getBlockReadOpsCountCounter().get());
    }
}

