/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.monitoring.ThreadLocalServerSideScanMetrics;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ParallelSeekHandler
extends EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelSeekHandler.class);
    private KeyValueScanner scanner;
    private Cell keyValue;
    private long readPoint;
    private CountDownLatch latch;
    private Throwable err = null;
    private final boolean isScanMetricsEnabled;
    private final AtomicLong bytesReadFromFs;
    private final AtomicLong bytesReadFromBlockCache;
    private final AtomicLong blockReadOpsCount;

    public ParallelSeekHandler(KeyValueScanner scanner, Cell keyValue, long readPoint, CountDownLatch latch) {
        super(null, EventType.RS_PARALLEL_SEEK);
        this.scanner = scanner;
        this.keyValue = keyValue;
        this.readPoint = readPoint;
        this.latch = latch;
        this.isScanMetricsEnabled = ThreadLocalServerSideScanMetrics.isScanMetricsEnabled();
        this.bytesReadFromFs = ThreadLocalServerSideScanMetrics.getBytesReadFromFsCounter();
        this.bytesReadFromBlockCache = ThreadLocalServerSideScanMetrics.getBytesReadFromBlockCacheCounter();
        this.blockReadOpsCount = ThreadLocalServerSideScanMetrics.getBlockReadOpsCountCounter();
    }

    @Override
    public void process() {
        try {
            ThreadLocalServerSideScanMetrics.setScanMetricsEnabled(this.isScanMetricsEnabled);
            if (this.isScanMetricsEnabled) {
                ThreadLocalServerSideScanMetrics.reset();
            }
            this.scanner.seek(this.keyValue);
            if (this.isScanMetricsEnabled) {
                long metricValue = ThreadLocalServerSideScanMetrics.getBytesReadFromFsAndReset();
                if (metricValue > 0L) {
                    this.bytesReadFromFs.addAndGet(metricValue);
                }
                if ((metricValue = ThreadLocalServerSideScanMetrics.getBytesReadFromBlockCacheAndReset()) > 0L) {
                    this.bytesReadFromBlockCache.addAndGet(metricValue);
                }
                if ((metricValue = ThreadLocalServerSideScanMetrics.getBlockReadOpsCountAndReset()) > 0L) {
                    this.blockReadOpsCount.addAndGet(metricValue);
                }
            }
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            this.setErr(e);
        }
        finally {
            this.latch.countDown();
        }
    }

    public Throwable getErr() {
        return this.err;
    }

    public void setErr(Throwable err) {
        this.err = err;
    }
}

