/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ModifyTableProcedure;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.regionserver.storefiletracker.MigrationStoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerBase;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ModifyStoreFileTrackerProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.ModifyStoreFileTrackerState> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyStoreFileTrackerProcedure.class);
    private TableName tableName;
    private String dstSFT;

    protected ModifyStoreFileTrackerProcedure() {
    }

    protected ModifyStoreFileTrackerProcedure(MasterProcedureEnv env, TableName tableName, String dstSFT) throws HBaseIOException {
        super(env);
        this.checkDstSFT(dstSFT);
        this.tableName = tableName;
        this.dstSFT = dstSFT;
        this.preflightChecks(env, true);
    }

    private void checkDstSFT(String dstSFT) throws DoNotRetryIOException {
        if (MigrationStoreFileTracker.class.isAssignableFrom(StoreFileTrackerFactory.getTrackerClass(dstSFT))) {
            throw new DoNotRetryIOException("Do not need to transfer to " + dstSFT);
        }
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private StoreFileTrackerState checkState(Configuration conf, String dstSFT) {
        Class<? extends StoreFileTracker> dstSFTClass;
        Class<? extends StoreFileTracker> clazz = StoreFileTrackerFactory.getTrackerClass(conf);
        if (clazz.equals(dstSFTClass = StoreFileTrackerFactory.getTrackerClass(dstSFT))) {
            return StoreFileTrackerState.ALREADY_FINISHED;
        }
        if (!MigrationStoreFileTracker.class.isAssignableFrom(clazz)) {
            return StoreFileTrackerState.NEED_START_MIGRATION;
        }
        Class<? extends StoreFileTrackerBase> currentDstSFT = StoreFileTrackerFactory.getStoreFileTrackerClassForMigration(conf, "hbase.store.file-tracker.migration.dst.impl");
        if (currentDstSFT.equals(dstSFTClass)) {
            return StoreFileTrackerState.NEED_FINISH_MIGRATION;
        }
        return StoreFileTrackerState.NEED_FINISH_PREVIOUS_MIGRATION_FIRST;
    }

    private final String getRestoreSFT(Configuration conf) {
        Class<? extends StoreFileTrackerBase> currentDstSFT = StoreFileTrackerFactory.getStoreFileTrackerClassForMigration(conf, "hbase.store.file-tracker.migration.dst.impl");
        return StoreFileTrackerFactory.getStoreFileTrackerName(currentDstSFT);
    }

    protected abstract void preCheck(TableDescriptor var1) throws IOException;

    protected abstract Configuration createConf(Configuration var1, TableDescriptor var2);

    protected abstract TableDescriptor createRestoreTableDescriptor(TableDescriptor var1, String var2);

    private StateMachineProcedure.Flow preCheckAndTryRestoreSFT(MasterProcedureEnv env) throws IOException {
        if (!env.getMasterServices().getTableDescriptors().exists(this.getTableName())) {
            throw new TableNotFoundException(this.getTableName());
        }
        if (!this.isTableEnabled(env)) {
            throw new TableNotEnabledException(this.tableName);
        }
        TableDescriptor current = env.getMasterServices().getTableDescriptors().get(this.tableName);
        this.preCheck(current);
        Configuration conf = this.createConf(env.getMasterConfiguration(), current);
        StoreFileTrackerState state = this.checkState(conf, this.dstSFT);
        switch (state) {
            case NEED_FINISH_PREVIOUS_MIGRATION_FIRST: {
                TableDescriptor td = this.createRestoreTableDescriptor(current, this.getRestoreSFT(conf));
                this.addChildProcedure((Procedure[])new ModifyTableProcedure[]{new ModifyTableProcedure(env, td)});
                this.setNextState(MasterProcedureProtos.ModifyStoreFileTrackerState.MODIFY_STORE_FILE_TRACKER_FINISH_PREVIOUS_MIGRATION);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case NEED_START_MIGRATION: {
                this.setNextState(MasterProcedureProtos.ModifyStoreFileTrackerState.MODIFY_STORE_FILE_TRACKER_START_MIGRATION);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case NEED_FINISH_MIGRATION: {
                this.setNextState(MasterProcedureProtos.ModifyStoreFileTrackerState.MODIFY_STORE_FILE_TRACKER_FINISH_MIGRATION);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case ALREADY_FINISHED: {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + (Object)((Object)state));
    }

    protected abstract TableDescriptor createMigrationTableDescriptor(Configuration var1, TableDescriptor var2);

    protected final void migrate(Configuration conf, BiConsumer<String, String> setValue) {
        setValue.accept("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name());
        setValue.accept("hbase.store.file-tracker.migration.src.impl", StoreFileTrackerFactory.getStoreFileTrackerName(conf));
        setValue.accept("hbase.store.file-tracker.migration.dst.impl", this.dstSFT);
    }

    protected abstract TableDescriptor createFinishTableDescriptor(TableDescriptor var1);

    protected final void finish(BiConsumer<String, String> setValue, Consumer<String> removeValue) {
        setValue.accept("hbase.store.file-tracker.impl", this.dstSFT);
        removeValue.accept("hbase.store.file-tracker.migration.src.impl");
        removeValue.accept("hbase.store.file-tracker.migration.dst.impl");
    }

    private void migrate(MasterProcedureEnv env) throws IOException {
        TableDescriptor current = env.getMasterServices().getTableDescriptors().get(this.tableName);
        TableDescriptor td = this.createMigrationTableDescriptor(env.getMasterConfiguration(), current);
        this.addChildProcedure((Procedure[])new ModifyTableProcedure[]{new ModifyTableProcedure(env, td)});
        this.setNextState(MasterProcedureProtos.ModifyStoreFileTrackerState.MODIFY_STORE_FILE_TRACKER_FINISH_MIGRATION);
    }

    private void finish(MasterProcedureEnv env) throws IOException {
        TableDescriptor current = env.getMasterServices().getTableDescriptors().get(this.tableName);
        TableDescriptor td = this.createFinishTableDescriptor(current);
        this.addChildProcedure((Procedure[])new ModifyTableProcedure[]{new ModifyTableProcedure(env, td)});
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ModifyStoreFileTrackerState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        try {
            switch (state) {
                case MODIFY_STORE_FILE_TRACKER_FINISH_PREVIOUS_MIGRATION: {
                    return this.preCheckAndTryRestoreSFT(env);
                }
                case MODIFY_STORE_FILE_TRACKER_START_MIGRATION: {
                    this.migrate(env);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case MODIFY_STORE_FILE_TRACKER_FINISH_MIGRATION: {
                    this.finish(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
            throw new UnsupportedOperationException("unhandled state=" + state);
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-modify-SFT", e);
            } else {
                LOG.warn("Retriable error trying to modify SFT for table={} (in state={})", new Object[]{this.getTableName(), state, e});
            }
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ModifyStoreFileTrackerState state) throws IOException, InterruptedException {
        if (this.isRollbackSupported(state)) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected MasterProcedureProtos.ModifyStoreFileTrackerState getState(int stateId) {
        return MasterProcedureProtos.ModifyStoreFileTrackerState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.ModifyStoreFileTrackerState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.ModifyStoreFileTrackerState getInitialState() {
        return MasterProcedureProtos.ModifyStoreFileTrackerState.MODIFY_STORE_FILE_TRACKER_FINISH_PREVIOUS_MIGRATION;
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.ModifyStoreFileTrackerState state) {
        return state == MasterProcedureProtos.ModifyStoreFileTrackerState.MODIFY_STORE_FILE_TRACKER_FINISH_PREVIOUS_MIGRATION;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.ModifyStoreFileTrackerStateData.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName)).setDstSft(this.dstSFT).build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ModifyStoreFileTrackerStateData data = (MasterProcedureProtos.ModifyStoreFileTrackerStateData)serializer.deserialize(MasterProcedureProtos.ModifyStoreFileTrackerStateData.class);
        this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)data.getTableName());
        this.dstSFT = data.getDstSft();
    }

    private static enum StoreFileTrackerState {
        NEED_FINISH_PREVIOUS_MIGRATION_FIRST,
        NEED_START_MIGRATION,
        NEED_FINISH_MIGRATION,
        ALREADY_FINISHED;

    }
}

