/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.lang.management.MemoryUsage;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl;
import org.apache.hadoop.hbase.util.DirectMemoryUtils;
import org.apache.hadoop.util.StringUtils;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class ServerMetricsTmplImpl
extends AbstractTemplateImpl
implements ServerMetricsTmpl.Intf {
    private final MetricsRegionServerWrapper mWrap;
    private final MetricsHBaseServerWrapper mServerWrap;
    private final ByteBuffAllocator bbAllocator;

    protected static ServerMetricsTmpl.ImplData __jamon_setOptionalArguments(ServerMetricsTmpl.ImplData p_implData) {
        return p_implData;
    }

    public ServerMetricsTmplImpl(TemplateManager p_templateManager, ServerMetricsTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)ServerMetricsTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.mWrap = p_implData.getMWrap();
        this.mServerWrap = p_implData.getMServerWrap();
        this.bbAllocator = p_implData.getBbAllocator();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\" role=\"tablist\">\n        <li class=\"nav-item\"><a class=\"nav-link active\" href=\"#tab_baseStats\" data-bs-toggle=\"tab\" role=\"tab\">Base Stats</a></li>\n        <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_memoryStats\" data-bs-toggle=\"tab\" role=\"tab\">Memory</a></li>\n        <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_requestStats\" data-bs-toggle=\"tab\" role=\"tab\">Requests</a></li>\n        <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_walStats\" data-bs-toggle=\"tab\" role=\"tab\">WALs</a></li>\n        <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_storeStats\" data-bs-toggle=\"tab\" role=\"tab\">Storefiles</a></li>\n        <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_queueStats\" data-bs-toggle=\"tab\" role=\"tab\">Queues</a></li>\n        <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_byteBuffAllocatorStats\" data-bs-toggle=\"tab\" role=\"tab\">ByteBuffAllocator Stats</a></li>\n    </ul>\n    <div class=\"tab-content\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\" role=\"tabpanel\">\n            ");
        this.__jamon_innerUnit__baseStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\" role=\"tabpanel\">\n            ");
        this.__jamon_innerUnit__memoryStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\" role=\"tabpanel\">\n            ");
        this.__jamon_innerUnit__requestStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_walStats\" role=\"tabpanel\">\n            ");
        this.__jamon_innerUnit__walStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\" role=\"tabpanel\">\n            ");
        this.__jamon_innerUnit__storeStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_queueStats\" role=\"tabpanel\">\n            ");
        this.__jamon_innerUnit__queueStats(jamonWriter, this.mWrap, this.mServerWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_byteBuffAllocatorStats\" role=\"tabpanel\">\n            ");
        this.__jamon_innerUnit__byteBuffAllocatorStats(jamonWriter, this.bbAllocator);
        jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }

    private void __jamon_innerUnit__baseStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n\n        <th>Requests Per Second</th>\n        <th>Num. Regions</th>\n        <th>Block locality</th>\n        <th>Block locality (Secondary replicas)</th>\n        <th>Slow WAL Append Count</th>\n    </tr>\n    <tr>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getNumOnlineRegions()), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%.3f", mWrap.getPercentFileLocal())), jamonWriter);
        Escaping.HTML.write(StandardEmitter.valueOf((String)"%"), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%.3f", mWrap.getPercentFileLocalSecondaryRegions())), jamonWriter);
        Escaping.HTML.write(StandardEmitter.valueOf((String)"%"), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getNumWALSlowAppend()), jamonWriter);
        jamonWriter.write("</td>\n    </tr>\n</table>\n");
    }

    private void __jamon_innerUnit__byteBuffAllocatorStats(Writer jamonWriter, ByteBuffAllocator bbAllocator) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Total Heap Allocation</th>\n    <th>Total Pool Allocation</th>\n    <th>Heap Allocation Ratio</th>\n    <th>Total Buffer Count</th>\n    <th>Used Buffer Count</th>\n    <th>Buffer Size</th>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)ByteBuffAllocator.getHeapAllocationBytes((ByteBuffAllocator[])new ByteBuffAllocator[]{bbAllocator, ByteBuffAllocator.HEAP}), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)bbAllocator.getPoolAllocationBytes(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%.3f", ByteBuffAllocator.getHeapAllocationRatio((ByteBuffAllocator[])new ByteBuffAllocator[]{bbAllocator, ByteBuffAllocator.HEAP}) * 100.0)), jamonWriter);
        Escaping.HTML.write(StandardEmitter.valueOf((String)"%"), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)bbAllocator.getTotalBufferCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)bbAllocator.getUsedBufferCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)bbAllocator.getBufferSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__memoryStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        long usedHeap = -1L;
        long maxHeap = -1L;
        MemoryUsage usage = MemorySizeUtil.safeGetHeapMemoryUsage();
        if (usage != null) {
            maxHeap = usage.getMax();
            usedHeap = usage.getUsed();
        }
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Used Heap</th>\n        <th>Max Heap</th>\n        <th>Direct Memory Used</th>\n        <th>Direct Memory Configured</th>\n        <th>Memstore On-Heap Size / Limit</th>\n        <th>Memstore Off-Heap Size / Limit</th>\n        <th>Memstore Data Size (On&&Off Heap)</th>\n    </tr>\n</tr>\n<tr>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)usedHeap, (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)maxHeap, (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)DirectMemoryUtils.getDirectMemoryUsage(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)DirectMemoryUtils.getDirectMemorySize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)(StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getOnHeapMemStoreSize(), (String)"B", (int)1) + " / " + StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getOnHeapMemStoreLimit(), (String)"B", (int)1))), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)(StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getOffHeapMemStoreSize(), (String)"B", (int)1) + " / " + StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getOffHeapMemStoreLimit(), (String)"B", (int)1))), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getMemStoreSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("\n    </td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__queueStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap, MetricsHBaseServerWrapper mServerWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Compaction Queue Length</th>\n    <th>Flush Queue Length</th>\n    <th>Priority Call Queue Length</th>\n    <th>General Call Queue Length</th>\n    <th>Replication Call Queue Length</th>\n    <th>Total Call Queue Size</th>\n\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)mWrap.getCompactionQueueSize()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)mWrap.getFlushQueueSize()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)mServerWrap.getPriorityQueueLength()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)mServerWrap.getGeneralQueueLength()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)mServerWrap.getReplicationQueueLength()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)mServerWrap.getTotalQueueSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__requestStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Filtered Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getReadRequestsCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getFilteredReadRequestsCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getWriteRequestsCount()), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__storeStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Root Index Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getNumStores()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getNumStoreFiles()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getStoreFileIndexSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getTotalStaticIndexSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getTotalStaticBloomSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__walStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Num. WAL Files</th>\n        <th>Size. WAL Files</th>\n        <th>WAL exclude DNs</th>\n    </tr>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)mWrap.getNumWALFiles()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getWALFileSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n    <td>\n        ");
        for (String exclude : mWrap.getWALExcludeDNs()) {
            jamonWriter.write("\n            ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)exclude), jamonWriter);
            jamonWriter.write("<br>\n        ");
        }
        jamonWriter.write("\n    </td>\n</tr>\n</table>\n");
    }
}

