/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.Priority;

public interface Job {
    public JobId getID();

    public String getName();

    public JobState getState();

    public JobReport getReport();

    public Counters getAllCounters();

    public Map<TaskId, Task> getTasks();

    public Map<TaskId, Task> getTasks(TaskType var1);

    public Task getTask(TaskId var1);

    public List<String> getDiagnostics();

    public int getTotalMaps();

    public int getTotalReduces();

    public int getCompletedMaps();

    public int getCompletedReduces();

    public float getProgress();

    public boolean isUber();

    public String getUserName();

    public String getQueueName();

    public Path getConfFile();

    public Configuration loadConfFile() throws IOException;

    public Map<JobACL, AccessControlList> getJobACLs();

    public TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int var1, int var2);

    public TaskCompletionEvent[] getMapAttemptCompletionEvents(int var1, int var2);

    public List<AMInfo> getAMInfos();

    public boolean checkAccess(UserGroupInformation var1, JobACL var2);

    public void setQueueName(String var1);

    public void setJobPriority(Priority var1);
}

