/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.PreemptableResourceCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.PreemptionCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ReservedContainerCandidatesSelector
extends PreemptionCandidatesSelector {
    private static final Log LOG = LogFactory.getLog(ReservedContainerCandidatesSelector.class);
    private PreemptableResourceCalculator preemptableAmountCalculator;

    ReservedContainerCandidatesSelector(CapacitySchedulerPreemptionContext preemptionContext) {
        super(preemptionContext);
        this.preemptableAmountCalculator = new PreemptableResourceCalculator(preemptionContext, true);
    }

    @Override
    public Map<ApplicationAttemptId, Set<RMContainer>> selectCandidates(Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Resource clusterResource, Resource totalPreemptedResourceAllowed) {
        this.preemptableAmountCalculator.computeIdealAllocation(clusterResource, totalPreemptedResourceAllowed);
        HashMap<String, Map<String, Resource>> queueToPreemptableResourceByPartition = new HashMap<String, Map<String, Resource>>();
        for (String leafQueue : this.preemptionContext.getLeafQueueNames()) {
            queueToPreemptableResourceByPartition.put(leafQueue, CapacitySchedulerPreemptionUtils.getResToObtainByPartitionForLeafQueue(this.preemptionContext, leafQueue, clusterResource));
        }
        List<NodeForPreemption> nodesForPreemption = this.getNodesForPreemption(clusterResource, queueToPreemptableResourceByPartition, selectedCandidates, totalPreemptedResourceAllowed);
        for (NodeForPreemption nfp : nodesForPreemption) {
            NodeForPreemption preemptionResult;
            RMContainer reservedContainer = nfp.schedulerNode.getReservedContainer();
            if (null == reservedContainer || null == (preemptionResult = this.getPreemptionCandidatesOnNode(nfp.schedulerNode, clusterResource, queueToPreemptableResourceByPartition, selectedCandidates, totalPreemptedResourceAllowed, false))) continue;
            for (RMContainer c : preemptionResult.selectedContainers) {
                ApplicationAttemptId appId = c.getApplicationAttemptId();
                Set<RMContainer> containers = selectedCandidates.get(appId);
                if (null == containers) {
                    containers = new HashSet<RMContainer>();
                    selectedCandidates.put(appId, containers);
                }
                containers.add(c);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(this.getClass().getName() + " Marked container=" + c.getContainerId() + " from queue=" + c.getQueueName() + " to be preemption candidates"));
            }
        }
        return selectedCandidates;
    }

    private Resource getPreemptableResource(String queueName, String partitionName, Map<String, Map<String, Resource>> queueToPreemptableResourceByPartition) {
        Map<String, Resource> partitionToPreemptable = queueToPreemptableResourceByPartition.get(queueName);
        if (null == partitionToPreemptable) {
            return null;
        }
        Resource preemptable = partitionToPreemptable.get(partitionName);
        return preemptable;
    }

    private boolean tryToPreemptFromQueue(Resource cluster, String queueName, String partitionName, Map<String, Map<String, Resource>> queueToPreemptableResourceByPartition, Resource required, Resource totalPreemptionAllowed, boolean readOnly) {
        Resource preemptable = this.getPreemptableResource(queueName, partitionName, queueToPreemptableResourceByPartition);
        if (null == preemptable) {
            return false;
        }
        if (!Resources.fitsIn((ResourceCalculator)this.rc, (Resource)cluster, (Resource)required, (Resource)preemptable)) {
            return false;
        }
        if (!Resources.fitsIn((ResourceCalculator)this.rc, (Resource)cluster, (Resource)required, (Resource)totalPreemptionAllowed)) {
            return false;
        }
        if (!readOnly) {
            Resources.subtractFrom((Resource)preemptable, (Resource)required);
            Resources.subtractFrom((Resource)totalPreemptionAllowed, (Resource)required);
        }
        return true;
    }

    private NodeForPreemption getPreemptionCandidatesOnNode(FiCaSchedulerNode node, Resource cluster, Map<String, Map<String, Resource>> queueToPreemptableResourceByPartition, Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Resource totalPreemptionAllowed, boolean readOnly) {
        RMContainer reservedContainer = node.getReservedContainer();
        Resource available = Resources.clone((Resource)node.getUnallocatedResource());
        Resource totalSelected = Resources.createResource((int)0);
        List<RMContainer> sortedRunningContainers = node.getCopiedListOfRunningContainers();
        ArrayList<RMContainer> selectedContainers = new ArrayList<RMContainer>();
        Map<ContainerId, RMContainer> killableContainers = node.getKillableContainers();
        Collections.sort(sortedRunningContainers, new Comparator<RMContainer>(){

            @Override
            public int compare(RMContainer o1, RMContainer o2) {
                return -1 * o1.getContainerId().compareTo(o2.getContainerId());
            }
        });
        boolean canAllocateReservedContainer = false;
        Resource cur = Resources.add((Resource)available, (Resource)node.getTotalKillableResources());
        String partition = node.getPartition();
        if (Resources.fitsIn((ResourceCalculator)this.rc, (Resource)cluster, (Resource)reservedContainer.getReservedResource(), (Resource)cur)) {
            return null;
        }
        float amPreemptionCost = 0.0f;
        for (RMContainer c : sortedRunningContainers) {
            String containerQueueName = c.getQueueName();
            if (killableContainers.containsKey(c.getContainerId())) continue;
            if (c.isAMContainer()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Skip selecting AM container on host=" + node.getNodeID() + " AM container=" + c.getContainerId()));
                continue;
            }
            boolean canPreempt = this.tryToPreemptFromQueue(cluster, containerQueueName, partition, queueToPreemptableResourceByPartition, c.getAllocatedResource(), totalPreemptionAllowed, readOnly);
            if (!canPreempt) continue;
            if (!CapacitySchedulerPreemptionUtils.isContainerAlreadySelected(c, selectedCandidates)) {
                if (!readOnly) {
                    selectedContainers.add(c);
                }
                Resources.addTo((Resource)totalSelected, (Resource)c.getAllocatedResource());
            }
            Resources.addTo((Resource)cur, (Resource)c.getAllocatedResource());
            if (!Resources.fitsIn((ResourceCalculator)this.rc, (Resource)cluster, (Resource)reservedContainer.getReservedResource(), (Resource)cur)) continue;
            canAllocateReservedContainer = true;
            break;
        }
        if (!canAllocateReservedContainer) {
            if (!readOnly) {
                for (RMContainer c : selectedContainers) {
                    Resource res = this.getPreemptableResource(c.getQueueName(), partition, queueToPreemptableResourceByPartition);
                    if (null == res) continue;
                    Resources.addTo((Resource)res, (Resource)c.getAllocatedResource());
                }
            }
            return null;
        }
        float ratio = Resources.ratio((ResourceCalculator)this.rc, (Resource)totalSelected, (Resource)reservedContainer.getReservedResource());
        NodeForPreemption nfp = new NodeForPreemption(ratio + amPreemptionCost, node, selectedContainers);
        return nfp;
    }

    private List<NodeForPreemption> getNodesForPreemption(Resource cluster, Map<String, Map<String, Resource>> queueToPreemptableResourceByPartition, Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Resource totalPreemptionAllowed) {
        ArrayList<NodeForPreemption> nfps = new ArrayList<NodeForPreemption>();
        for (FiCaSchedulerNode node : this.preemptionContext.getScheduler().getAllNodes()) {
            NodeForPreemption nfp;
            if (node.getReservedContainer() == null || null == (nfp = this.getPreemptionCandidatesOnNode(node, cluster, queueToPreemptableResourceByPartition, selectedCandidates, totalPreemptionAllowed, true))) continue;
            nfps.add(nfp);
        }
        Collections.sort(nfps, new Comparator<NodeForPreemption>(){

            @Override
            public int compare(NodeForPreemption o1, NodeForPreemption o2) {
                return Float.compare(o1.preemptionCost, o2.preemptionCost);
            }
        });
        return nfps;
    }

    private static class NodeForPreemption {
        private float preemptionCost;
        private FiCaSchedulerNode schedulerNode;
        private List<RMContainer> selectedContainers;

        public NodeForPreemption(float preemptionCost, FiCaSchedulerNode schedulerNode, List<RMContainer> selectedContainers) {
            this.preemptionCost = preemptionCost;
            this.schedulerNode = schedulerNode;
            this.selectedContainers = selectedContainers;
        }
    }
}

