/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.LoadableSchemaObject;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaUtils;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.registries.NormalizerRegistry;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.context.FilteringOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;

public class SchemaService {
    private static Entry schemaSubentry;
    private static Object schemaSubentrLock;

    private static Attribute generateComparators(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.lookupAttributeTypeRegistry("comparators"));
        for (LdapComparator comparator : schemaManager.getComparatorRegistry()) {
            attr.add(new String[]{SchemaUtils.render((LoadableSchemaObject)comparator)});
        }
        return attr;
    }

    private static Attribute generateNormalizers(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("normalizers"));
        NormalizerRegistry nr = schemaManager.getNormalizerRegistry();
        for (Normalizer normalizer : nr) {
            attr.add(new String[]{SchemaUtils.render((LoadableSchemaObject)normalizer)});
        }
        return attr;
    }

    private static Attribute generateSyntaxCheckers(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("syntaxCheckers"));
        for (SyntaxChecker syntaxChecker : schemaManager.getSyntaxCheckerRegistry()) {
            attr.add(new String[]{SchemaUtils.render((LoadableSchemaObject)syntaxChecker)});
        }
        return attr;
    }

    private static Attribute generateObjectClasses(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("objectClasses"));
        for (ObjectClass objectClass : schemaManager.getObjectClassRegistry()) {
            attr.add(new String[]{SchemaUtils.render((ObjectClass)objectClass).toString()});
        }
        return attr;
    }

    private static Attribute generateAttributeTypes(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("attributeTypes"));
        for (AttributeType attributeType : schemaManager.getAttributeTypeRegistry()) {
            attr.add(new String[]{SchemaUtils.render((AttributeType)attributeType).toString()});
        }
        return attr;
    }

    private static Attribute generateMatchingRules(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("matchingRules"));
        for (MatchingRule matchingRule : schemaManager.getMatchingRuleRegistry()) {
            attr.add(new String[]{SchemaUtils.render((MatchingRule)matchingRule).toString()});
        }
        return attr;
    }

    private static Attribute generateMatchingRuleUses(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("matchingRuleUse"));
        for (MatchingRuleUse matchingRuleUse : schemaManager.getMatchingRuleUseRegistry()) {
            attr.add(new String[]{SchemaUtils.render((MatchingRuleUse)matchingRuleUse).toString()});
        }
        return attr;
    }

    private static Attribute generateSyntaxes(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("ldapSyntaxes"));
        for (LdapSyntax syntax : schemaManager.getLdapSyntaxRegistry()) {
            attr.add(new String[]{SchemaUtils.render((LdapSyntax)syntax).toString()});
        }
        return attr;
    }

    private static Attribute generateDitContextRules(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("ditContentRules"));
        for (DitContentRule ditContentRule : schemaManager.getDITContentRuleRegistry()) {
            attr.add(new String[]{SchemaUtils.render((DitContentRule)ditContentRule).toString()});
        }
        return attr;
    }

    private static Attribute generateDitStructureRules(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("ditStructureRules"));
        for (DitStructureRule ditStructureRule : schemaManager.getDITStructureRuleRegistry()) {
            attr.add(new String[]{SchemaUtils.render((DitStructureRule)ditStructureRule).toString()});
        }
        return attr;
    }

    private static Attribute generateNameForms(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("nameForms"));
        for (NameForm nameForm : schemaManager.getNameFormRegistry()) {
            attr.add(new String[]{SchemaUtils.render((NameForm)nameForm).toString()});
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateSchemaSubentry(SchemaManager schemaManager, Entry mods) throws LdapException {
        DefaultEntry attrs = new DefaultEntry(schemaManager, mods.getDn());
        attrs.put("objectClass", new String[]{"top", "subschema", "subentry", "apacheSubschema"});
        attrs.put("cn", new String[]{"schema"});
        attrs.put(new Attribute[]{SchemaService.generateComparators(schemaManager)});
        attrs.put(new Attribute[]{SchemaService.generateNormalizers(schemaManager)});
        attrs.put(new Attribute[]{SchemaService.generateSyntaxCheckers(schemaManager)});
        attrs.put(new Attribute[]{SchemaService.generateObjectClasses(schemaManager)});
        attrs.put(new Attribute[]{SchemaService.generateAttributeTypes(schemaManager)});
        attrs.put(new Attribute[]{SchemaService.generateMatchingRules(schemaManager)});
        attrs.put(new Attribute[]{SchemaService.generateMatchingRuleUses(schemaManager)});
        attrs.put(new Attribute[]{SchemaService.generateSyntaxes(schemaManager)});
        attrs.put(new Attribute[]{SchemaService.generateDitContextRules(schemaManager)});
        attrs.put(new Attribute[]{SchemaService.generateDitStructureRules(schemaManager)});
        attrs.put(new Attribute[]{SchemaService.generateNameForms(schemaManager)});
        attrs.put("subtreeSpecification", new String[]{"{}"});
        Attribute createTimestamp = mods.get("createTimestamp");
        attrs.put("createTimestamp", new Value[]{createTimestamp.get()});
        attrs.put("creatorsName", new String[]{"uid=admin,ou=system"});
        Attribute schemaModifyTimestamp = mods.get("schemaModifyTimestamp");
        attrs.put("modifyTimestamp", new Value[]{schemaModifyTimestamp.get()});
        Attribute schemaModifiersName = mods.get("schemaModifiersName");
        attrs.put("modifiersName", new Value[]{schemaModifiersName.get()});
        Object object = schemaSubentrLock;
        synchronized (object) {
            schemaSubentry = attrs;
        }
    }

    private static void addAttribute(Entry attrs, String id) throws LdapException {
        Attribute attr = schemaSubentry.get(id);
        if (attr != null && attr.size() > 0) {
            attrs.put(new Attribute[]{attr});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry getSubschemaEntryImmutable(DirectoryService directoryService) throws LdapException {
        Object object = schemaSubentrLock;
        synchronized (object) {
            if (schemaSubentry == null) {
                Dn schemaModificationAttributesDn = new Dn(directoryService.getSchemaManager(), new String[]{"ou=schemaModifications,ou=schema"});
                SchemaService.generateSchemaSubentry(directoryService.getSchemaManager(), directoryService.getSchemaPartition().lookup(new LookupOperationContext(null, schemaModificationAttributesDn)));
            }
            return schemaSubentry.clone();
        }
    }

    public static Entry getSubschemaEntryCloned(DirectoryService directoryService) throws LdapException {
        if (schemaSubentry == null) {
            Dn schemaModificationAttributesDn = new Dn(directoryService.getSchemaManager(), new String[]{"ou=schemaModifications,ou=schema"});
            SchemaService.generateSchemaSubentry(directoryService.getSchemaManager(), directoryService.getSchemaPartition().lookup(new LookupOperationContext(null, schemaModificationAttributesDn)));
        }
        return schemaSubentry.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry getSubschemaEntry(DirectoryService directoryService, FilteringOperationContext operationContext) throws LdapException {
        SchemaManager schemaManager = directoryService.getSchemaManager();
        DefaultEntry attrs = new DefaultEntry(schemaManager, Dn.ROOT_DSE);
        Object object = schemaSubentrLock;
        synchronized (object) {
            Dn schemaModificationAttributesDn = new Dn(directoryService.getSchemaManager(), new String[]{"ou=schemaModifications,ou=schema"});
            Entry mods = directoryService.getSchemaPartition().lookup(new LookupOperationContext(null, schemaModificationAttributesDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY));
            SchemaService.generateSchemaSubentry(schemaManager, mods);
            SchemaService.addAttribute((Entry)attrs, "comparators");
            SchemaService.addAttribute((Entry)attrs, "normalizers");
            SchemaService.addAttribute((Entry)attrs, "syntaxCheckers");
            SchemaService.addAttribute((Entry)attrs, "objectClasses");
            SchemaService.addAttribute((Entry)attrs, "attributeTypes");
            SchemaService.addAttribute((Entry)attrs, "matchingRules");
            SchemaService.addAttribute((Entry)attrs, "matchingRuleUse");
            SchemaService.addAttribute((Entry)attrs, "ldapSyntaxes");
            SchemaService.addAttribute((Entry)attrs, "ditContentRules");
            SchemaService.addAttribute((Entry)attrs, "ditStructureRules");
            SchemaService.addAttribute((Entry)attrs, "nameForms");
            SchemaService.addAttribute((Entry)attrs, "subtreeSpecification");
            SchemaService.addAttribute((Entry)attrs, "objectClass");
            SchemaService.addAttribute((Entry)attrs, "cn");
            SchemaService.addAttribute((Entry)attrs, "createTimestamp");
            SchemaService.addAttribute((Entry)attrs, "creatorsName");
            SchemaService.addAttribute((Entry)attrs, "modifyTimestamp");
            SchemaService.addAttribute((Entry)attrs, "modifiersName");
            SchemaService.addAttribute((Entry)attrs, "entryUUID");
            SchemaService.addAttribute((Entry)attrs, "entryDN");
        }
        ClonedServerEntry result = new ClonedServerEntry((Entry)attrs);
        return result;
    }

    static {
        schemaSubentrLock = new Object();
    }
}

