/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.UserMetrics;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.field.FieldValue;
import org.apache.hadoop.hbase.hbtop.field.FieldValueType;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.mode.ModeStrategy;
import org.apache.hadoop.hbase.hbtop.mode.ModeStrategyUtils;
import org.apache.hadoop.hbase.hbtop.mode.RequestCountPerSecond;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ClientModeStrategy
implements ModeStrategy {
    private final List<FieldInfo> fieldInfos = Arrays.asList(new FieldInfo(Field.CLIENT, 0, true), new FieldInfo(Field.USER_COUNT, 5, true), new FieldInfo(Field.REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.READ_REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.WRITE_REQUEST_COUNT_PER_SECOND, 10, true), new FieldInfo(Field.FILTERED_READ_REQUEST_COUNT_PER_SECOND, 10, true));
    private final Map<String, RequestCountPerSecond> requestCountPerSecondMap = new HashMap<String, RequestCountPerSecond>();

    ClientModeStrategy() {
    }

    @Override
    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public Field getDefaultSortField() {
        return Field.REQUEST_COUNT_PER_SECOND;
    }

    @Override
    public List<Record> getRecords(ClusterMetrics clusterMetrics, List<RecordFilter> pushDownFilters) {
        List<Record> records = this.createRecords(clusterMetrics);
        return this.aggregateRecordsAndAddDistinct(ModeStrategyUtils.applyFilterAndGet(records, pushDownFilters), Field.CLIENT, Field.USER, Field.USER_COUNT);
    }

    List<Record> createRecords(ClusterMetrics clusterMetrics) {
        ArrayList<Record> ret = new ArrayList<Record>();
        for (ServerMetrics serverMetrics : clusterMetrics.getLiveServerMetrics().values()) {
            long lastReportTimestamp = serverMetrics.getLastReportTimestamp();
            serverMetrics.getUserMetrics().values().forEach(um -> um.getClientMetrics().values().forEach(clientMetrics -> ret.add(this.createRecord(um.getNameAsString(), (UserMetrics.ClientMetrics)clientMetrics, lastReportTimestamp, serverMetrics.getServerName().getServerName()))));
        }
        return ret;
    }

    List<Record> aggregateRecordsAndAddDistinct(List<Record> records, Field groupBy, Field distinctField, Field uniqueCountAssignedTo) {
        ArrayList<Record> result = new ArrayList<Record>();
        records.stream().collect(Collectors.groupingBy(r -> r.get((Object)groupBy))).values().forEach(val -> {
            HashSet<FieldValue> distinctValues = new HashSet<FieldValue>();
            HashMap<Field, FieldValue> map = new HashMap<Field, FieldValue>();
            for (Record record : val) {
                for (Map.Entry<Field, FieldValue> field : record.entrySet()) {
                    if (distinctField.equals((Object)field.getKey())) {
                        distinctValues.add(record.get((Object)distinctField));
                        continue;
                    }
                    if (field.getKey().getFieldValueType() == FieldValueType.STRING) {
                        map.put(field.getKey(), field.getValue());
                        continue;
                    }
                    if (map.get((Object)field.getKey()) == null) {
                        map.put(field.getKey(), field.getValue());
                        continue;
                    }
                    map.put(field.getKey(), ((FieldValue)map.get((Object)field.getKey())).plus(field.getValue()));
                }
            }
            map.put(uniqueCountAssignedTo, uniqueCountAssignedTo.newValue(distinctValues.size()));
            result.add(Record.ofEntries(map.entrySet().stream().map(k -> Record.entry((Field)((Object)((Object)((Object)k.getKey()))), (FieldValue)k.getValue()))));
        });
        return result;
    }

    Record createRecord(String user, UserMetrics.ClientMetrics clientMetrics, long lastReportTimestamp, String server) {
        Record.Builder builder = Record.builder();
        String client = clientMetrics.getHostName();
        builder.put(Field.CLIENT, clientMetrics.getHostName());
        String mapKey = client + "$" + user + "$" + server;
        RequestCountPerSecond requestCountPerSecond = this.requestCountPerSecondMap.get(mapKey);
        if (requestCountPerSecond == null) {
            requestCountPerSecond = new RequestCountPerSecond();
            this.requestCountPerSecondMap.put(mapKey, requestCountPerSecond);
        }
        requestCountPerSecond.refresh(lastReportTimestamp, clientMetrics.getReadRequestsCount(), clientMetrics.getFilteredReadRequestsCount(), clientMetrics.getWriteRequestsCount());
        builder.put(Field.REQUEST_COUNT_PER_SECOND, requestCountPerSecond.getRequestCountPerSecond());
        builder.put(Field.READ_REQUEST_COUNT_PER_SECOND, requestCountPerSecond.getReadRequestCountPerSecond());
        builder.put(Field.WRITE_REQUEST_COUNT_PER_SECOND, requestCountPerSecond.getWriteRequestCountPerSecond());
        builder.put(Field.FILTERED_READ_REQUEST_COUNT_PER_SECOND, requestCountPerSecond.getFilteredReadRequestCountPerSecond());
        builder.put(Field.USER, user);
        return builder.build();
    }

    @Override
    public DrillDownInfo drillDown(Record selectedRecord) {
        List<RecordFilter> initialFilters = Collections.singletonList(RecordFilter.newBuilder(Field.CLIENT).doubleEquals(selectedRecord.get((Object)Field.CLIENT)));
        return new DrillDownInfo(Mode.USER, initialFilters);
    }
}

