/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ValueRewritingObserver
implements RegionObserver,
RegionCoprocessor {
    public static final String ORIGINAL_VALUE_KEY = "hbase.examples.coprocessor.value.rewrite.orig";
    public static final String REPLACED_VALUE_KEY = "hbase.examples.coprocessor.value.rewrite.replaced";
    private byte[] sourceValue = null;
    private byte[] replacedValue = null;
    private Bytes.ByteArrayComparator comparator;
    private CellBuilder cellBuilder;

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        RegionCoprocessorEnvironment renv = (RegionCoprocessorEnvironment)env;
        this.sourceValue = Bytes.toBytes((String)renv.getConfiguration().get(ORIGINAL_VALUE_KEY));
        this.replacedValue = Bytes.toBytes((String)renv.getConfiguration().get(REPLACED_VALUE_KEY));
        this.comparator = new Bytes.ByteArrayComparator();
        this.cellBuilder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY);
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, final InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) {
        InternalScanner modifyingScanner = new InternalScanner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
                boolean ret = scanner.next(result, scannerContext);
                for (int i = 0; i < result.size(); ++i) {
                    Cell c = result.get(i);
                    if (!CellUtil.isPut((Cell)c) || ValueRewritingObserver.this.comparator.compare(CellUtil.cloneValue((Cell)c), ValueRewritingObserver.this.sourceValue) != 0) continue;
                    try {
                        ValueRewritingObserver.this.cellBuilder.setRow(CellUtil.copyRow((Cell)c));
                        ValueRewritingObserver.this.cellBuilder.setFamily(CellUtil.cloneFamily((Cell)c));
                        ValueRewritingObserver.this.cellBuilder.setQualifier(CellUtil.cloneQualifier((Cell)c));
                        ValueRewritingObserver.this.cellBuilder.setTimestamp(c.getTimestamp());
                        ValueRewritingObserver.this.cellBuilder.setType(Cell.Type.Put);
                        byte[] clonedValue = new byte[ValueRewritingObserver.this.replacedValue.length];
                        System.arraycopy(ValueRewritingObserver.this.replacedValue, 0, clonedValue, 0, ValueRewritingObserver.this.replacedValue.length);
                        ValueRewritingObserver.this.cellBuilder.setValue(clonedValue);
                        result.set(i, ValueRewritingObserver.this.cellBuilder.build());
                        continue;
                    }
                    finally {
                        ValueRewritingObserver.this.cellBuilder.clear();
                    }
                }
                return ret;
            }

            public void close() throws IOException {
                scanner.close();
            }
        };
        return modifyingScanner;
    }
}

