/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.optimizer.affinity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionJoinCondition;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionJoinGroup;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionTable;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionTableAffinityDescriptor;
import org.jetbrains.annotations.Nullable;

public class PartitionTableModel {
    public static final int GRP_NONE = -1;
    private final Map<String, PartitionTable> tbls = new HashMap<String, PartitionTable>();
    private final Map<Integer, PartitionJoinGroup> grps = new HashMap<Integer, PartitionJoinGroup>();
    private Set<String> excludedTblNames;
    private int grpIdxGen;

    public void addTable(PartitionTable tbl, PartitionTableAffinityDescriptor aff) {
        int grpIdx = this.grpIdxGen++;
        tbl.joinGroup(grpIdx);
        this.tbls.put(tbl.alias(), tbl);
        this.grps.put(grpIdx, new PartitionJoinGroup(aff).addTable(tbl));
    }

    @Nullable
    public PartitionTable table(String alias) {
        PartitionTable res = this.tbls.get(alias);
        assert (res != null || this.excludedTblNames != null && this.excludedTblNames.contains(alias));
        return res;
    }

    public void addExcludedTable(String alias) {
        PartitionTable tbl = this.tbls.remove(alias);
        if (tbl != null) {
            PartitionJoinGroup grp = this.grps.get(tbl.joinGroup());
            assert (grp != null);
            if (grp.removeTable(tbl)) {
                this.grps.remove(tbl.joinGroup());
            }
        }
        if (this.excludedTblNames == null) {
            this.excludedTblNames = new HashSet<String>();
        }
        this.excludedTblNames.add(alias);
    }

    public void addJoin(PartitionJoinCondition cond) {
        PartitionTable leftTbl = this.tbls.get(cond.leftAlias());
        PartitionTable rightTbl = this.tbls.get(cond.rightAlias());
        assert (leftTbl != null || this.excludedTblNames != null && this.excludedTblNames.contains(cond.leftAlias()));
        assert (rightTbl != null || this.excludedTblNames != null && this.excludedTblNames.contains(cond.rightAlias()));
        if (leftTbl == null || rightTbl == null) {
            return;
        }
        if (!leftTbl.isAffinityColumn(cond.leftColumn()) || !rightTbl.isAffinityColumn(cond.rightColumn())) {
            return;
        }
        int rightGrpId = rightTbl.joinGroup();
        PartitionJoinGroup leftGrp = this.grps.get(leftTbl.joinGroup());
        PartitionJoinGroup rightGrp = this.grps.get(rightGrpId);
        assert (leftGrp != null);
        assert (rightGrp != null);
        if (!leftGrp.affinityDescriptor().isCompatible(rightGrp.affinityDescriptor())) {
            return;
        }
        for (PartitionTable tbl : rightGrp.tables()) {
            tbl.joinGroup(leftTbl.joinGroup());
            leftGrp.addTable(tbl);
        }
        this.grps.remove(rightGrpId);
    }

    @Nullable
    public PartitionTableAffinityDescriptor joinGroupAffinity(int grpId) {
        if (grpId == -1) {
            return null;
        }
        PartitionJoinGroup grp = this.grps.get(grpId);
        assert (grp != null);
        return grp.affinityDescriptor();
    }
}

