/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ssl;

import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.ignite.ssl.SSLServerSocketFactoryWrapper;
import org.apache.ignite.ssl.SSLSocketFactoryWrapper;

class DelegatingSSLContextSpi
extends SSLContextSpi {
    private final SSLContext delegate;
    private final SSLParameters parameters;

    DelegatingSSLContextSpi(SSLContext delegate, SSLParameters parameters) {
        this.delegate = delegate;
        this.parameters = parameters;
    }

    @Override
    protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws KeyManagementException {
        this.delegate.init(keyManagers, trustManagers, secureRandom);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return new SSLSocketFactoryWrapper(this.delegate.getSocketFactory(), this.parameters);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return new SSLServerSocketFactoryWrapper(this.delegate.getServerSocketFactory(), this.parameters);
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        SSLEngine engine = this.delegate.createSSLEngine();
        if (this.parameters != null) {
            engine.setSSLParameters(this.parameters);
        }
        return engine;
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String s, int i) {
        SSLEngine engine = this.delegate.createSSLEngine();
        if (this.parameters != null) {
            engine.setSSLParameters(this.parameters);
        }
        return engine;
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.delegate.getServerSessionContext();
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.delegate.getClientSessionContext();
    }

    @Override
    protected SSLParameters engineGetDefaultSSLParameters() {
        return this.delegate.getDefaultSSLParameters();
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        return this.delegate.getSupportedSSLParameters();
    }
}

