/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.PersonTextIndex;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

abstract class IgniteCacheQueryGetAllBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    protected static final String namePrefix = "personName";
    private boolean keepBinary;
    private int pageSize;

    IgniteCacheQueryGetAllBenchmark() {
    }

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.keepBinary = this.args.getBooleanParameter("keepBinary", false);
        this.pageSize = this.args.getIntParameter("pageSize", 1024);
        BenchmarkUtils.println((String)("Parameters of test: [keepBinary=" + this.keepBinary + "; pageSize=" + this.pageSize + "]."));
        this.loadCachesData();
    }

    @Override
    protected void loadCacheData(String cacheName) {
        try (IgniteDataStreamer dataLdr = this.ignite().dataStreamer(cacheName);){
            for (int i = 0; i < this.args.range() && !Thread.currentThread().isInterrupted(); ++i) {
                dataLdr.addData((Object)i, (Object)new PersonTextIndex(i, namePrefix + i));
                if (i % 100000 != 0) continue;
                BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Populated persons: " + i));
            }
        }
    }

    protected boolean testCacheQuery(Query<?> cacheQry) {
        IgniteCache cache = this.cacheForOperation();
        if (this.keepBinary) {
            cache = cache.withKeepBinary();
        }
        cacheQry.setPageSize(this.pageSize);
        QueryCursor cursor = cache.query(cacheQry);
        for (Object e : cursor) {
        }
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("query");
    }
}

