/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Collection;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.yardstickframework.BenchmarkUtils;

public class WaitMapExchangeFinishCallable
implements IgniteCallable<Void> {
    @IgniteInstanceResource
    private Ignite ignite;

    public Void call() throws Exception {
        Collection cachesx = ((IgniteKernal)this.ignite).cachesx(null);
        for (IgniteInternalCache cache : cachesx) {
            try {
                GridDhtPartitionTopology top = cache.context().isNear() ? cache.context().near().dht().topology() : cache.context().dht().topology();
                BenchmarkUtils.println((String)("Validating cache: " + cache.name()));
                while (true) {
                    boolean success = true;
                    if (top.readyTopologyVersion().topologyVersion() == this.ignite.cluster().topologyVersion()) {
                        for (Map.Entry e : top.partitionMap(true).entrySet()) {
                            for (Map.Entry p : ((GridDhtPartitionMap)e.getValue()).entrySet()) {
                                if (p.getValue() == GridDhtPartitionState.OWNING) continue;
                                BenchmarkUtils.println((String)("Not owning partition [part=" + p.getKey() + ", state=" + p.getValue() + "]"));
                                success = false;
                                break;
                            }
                            if (success) continue;
                            break;
                        }
                    } else {
                        BenchmarkUtils.println((String)("Topology version is different [cache=" + top.readyTopologyVersion() + ", cluster=" + this.ignite.cluster().topologyVersion() + "]"));
                        success = false;
                    }
                    if (success) break;
                    Thread.sleep(1000L);
                }
                BenchmarkUtils.println((String)("Cache state is fine: " + cache.name()));
            }
            catch (RuntimeException e1) {
                BenchmarkUtils.println((String)("Ignored exception: " + e1));
            }
        }
        return null;
    }
}

