/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.upload;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.ignite.yardstick.upload.AbstractUploadBenchmark;

public class BatchedInsertBenchmark
extends AbstractUploadBenchmark {
    private long batchSize;

    @Override
    protected void init() {
        this.batchSize = this.args.upload.jdbcBatchSize();
    }

    @Override
    protected void warmup(Connection warmupConn) throws SQLException {
        this.performBatchUpdate(warmupConn, this.warmupRowsCnt);
    }

    @Override
    public void upload(Connection uploadConn) throws Exception {
        this.performBatchUpdate(uploadConn, this.insertRowsCnt);
    }

    private void performBatchUpdate(Connection uploadConn, long rowsCnt) throws SQLException {
        try (PreparedStatement insert = uploadConn.prepareStatement(this.queries.insert());){
            for (long id = 1L; id <= rowsCnt; ++id) {
                this.queries.setRandomInsertArgs(insert, id);
                insert.addBatch();
                if (id % this.batchSize != 0L && id != rowsCnt) continue;
                insert.executeBatch();
            }
        }
    }
}

