/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.jta.websphere;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.cache.configuration.Factory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.ignite.IgniteException;

public class WebSphereTmFactory
implements Factory<TransactionManager> {
    private static final long serialVersionUID = 0L;
    private static final Class<?> onePhaseXAResourceCls;

    public TransactionManager create() {
        try {
            Class<?> clazz = Class.forName("com.ibm.tx.jta.impl.TranManagerSet");
            Method m = clazz.getMethod("instance", null);
            TransactionManager tranMgr = (TransactionManager)m.invoke(null, (Object[])null);
            return new WebSphereTransactionManager(tranMgr);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    static {
        try {
            onePhaseXAResourceCls = Class.forName("com.ibm.tx.jta.OnePhaseXAResource");
        }
        catch (ClassNotFoundException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private static class WebSphereTransaction
    implements Transaction {
        private final Transaction tx;

        WebSphereTransaction(Transaction tx) {
            assert (tx != null);
            this.tx = tx;
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            this.tx.commit();
        }

        public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
            return this.tx.delistResource(xaRes, flag);
        }

        public boolean enlistResource(final XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
            if (xaRes == null) {
                return false;
            }
            Object ibmProxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{onePhaseXAResourceCls}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
                    return mtd.invoke((Object)xaRes, args);
                }
            });
            return this.tx.enlistResource((XAResource)ibmProxy);
        }

        public int getStatus() throws SystemException {
            return this.tx.getStatus();
        }

        public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
            this.tx.registerSynchronization(sync);
        }

        public void rollback() throws IllegalStateException, SystemException {
            this.tx.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.tx.setRollbackOnly();
        }
    }

    private static class WebSphereTransactionManager
    implements TransactionManager {
        private TransactionManager mgr;

        WebSphereTransactionManager(TransactionManager mgr) {
            this.mgr = mgr;
        }

        public void begin() throws NotSupportedException, SystemException {
            this.mgr.begin();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            this.mgr.commit();
        }

        public int getStatus() throws SystemException {
            return this.mgr.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            Transaction tx = this.mgr.getTransaction();
            if (tx == null) {
                return null;
            }
            return new WebSphereTransaction(tx);
        }

        public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
            this.mgr.resume(tobj);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.mgr.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.mgr.setRollbackOnly();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.mgr.setTransactionTimeout(seconds);
        }

        public Transaction suspend() throws SystemException {
            return this.mgr.suspend();
        }
    }
}

