/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Collections;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptor;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessage;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.OutNetworkObject;

public class InboundRecoveryHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "inbound-recovery-handler";
    private final RecoveryDescriptor descriptor;
    private final NetworkMessagesFactory factory;

    public InboundRecoveryHandler(RecoveryDescriptor descriptor, NetworkMessagesFactory factory) {
        this.descriptor = descriptor;
        this.factory = factory;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        NetworkMessage message = (NetworkMessage)msg;
        if (message instanceof AcknowledgementMessage) {
            AcknowledgementMessage ackMessage = (AcknowledgementMessage)msg;
            long receivedMessages = ackMessage.receivedMessages();
            this.descriptor.acknowledge(receivedMessages);
        } else if (message.needAck()) {
            AcknowledgementMessage ackMsg = this.factory.acknowledgementMessage().receivedMessages(this.descriptor.onReceive()).build();
            ctx.channel().writeAndFlush((Object)new OutNetworkObject(ackMsg, Collections.emptyList(), false));
        }
        super.channelRead(ctx, (Object)message);
    }
}

