/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.internal.deployunit.DeploymentUnit;
import org.apache.ignite.internal.deployunit.exception.DeploymentUnitReadException;

public class UnitContent
implements Iterable<Map.Entry<String, byte[]>> {
    private final Map<String, byte[]> files;

    public UnitContent(Map<String, byte[]> files) {
        this.files = files;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnitContent that = (UnitContent)o;
        if (this.files.size() != that.files.size()) {
            return false;
        }
        for (Map.Entry<String, byte[]> e : this.files.entrySet()) {
            String key = e.getKey();
            byte[] value = e.getValue();
            if (!(value == null ? that.files.get(key) != null || !that.files.containsKey(key) : !Arrays.equals(value, that.files.get(key)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.files.hashCode();
    }

    @Override
    public Iterator<Map.Entry<String, byte[]>> iterator() {
        return this.files.entrySet().iterator();
    }

    public static UnitContent readContent(DeploymentUnit deploymentUnit) {
        Map<String, byte[]> map = deploymentUnit.content().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return ((InputStream)entry.getValue()).readAllBytes();
            }
            catch (IOException e) {
                throw new DeploymentUnitReadException(e);
            }
        }));
        return new UnitContent(map);
    }

    public static DeploymentUnit toDeploymentUnit(UnitContent content) {
        HashMap<String, InputStream> files = new HashMap<String, InputStream>();
        content.iterator().forEachRemaining(it -> files.put((String)it.getKey(), new ByteArrayInputStream((byte[])it.getValue())));
        return new DeploymentUnit(files);
    }
}

