/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.jetbrains.annotations.Nullable;

class CatalogStorageIndexDescriptorSupplier
implements StorageIndexDescriptorSupplier {
    private final CatalogService catalogService;
    private final LowWatermark lowWatermark;

    CatalogStorageIndexDescriptorSupplier(CatalogService catalogService, LowWatermark lowWatermark) {
        this.catalogService = catalogService;
        this.lowWatermark = lowWatermark;
    }

    @Nullable
    public StorageIndexDescriptor get(int indexId) {
        int latestCatalogVersion = this.catalogService.latestCatalogVersion();
        HybridTimestamp lowWatermarkTimestamp = this.lowWatermark.getLowWatermark();
        int earliestCatalogVersion = lowWatermarkTimestamp == null ? this.catalogService.earliestCatalogVersion() : this.catalogService.activeCatalogVersion(lowWatermarkTimestamp.longValue());
        for (int catalogVersion = latestCatalogVersion; catalogVersion >= earliestCatalogVersion; --catalogVersion) {
            CatalogIndexDescriptor index = this.catalogService.index(indexId, catalogVersion);
            if (index == null) continue;
            return this.createStorageIndexDescriptor(index, catalogVersion);
        }
        return null;
    }

    private StorageIndexDescriptor createStorageIndexDescriptor(CatalogIndexDescriptor indexDescriptor, int catalogVersion) {
        CatalogTableDescriptor table = this.catalogService.table(indexDescriptor.tableId(), catalogVersion);
        assert (table != null) : "tableId=" + indexDescriptor.tableId() + ", indexId=" + indexDescriptor.id();
        return StorageIndexDescriptor.create((CatalogTableDescriptor)table, (CatalogIndexDescriptor)indexDescriptor);
    }
}

