/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.pagememory.Storable;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.apache.ignite.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.pagememory.mv.HybridTimestamps;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public final class RowVersion
implements Storable {
    public static final byte DATA_TYPE = 0;
    private static final int NEXT_LINK_STORE_SIZE_BYTES = 6;
    private static final int VALUE_SIZE_STORE_SIZE_BYTES = 4;
    private static final int SCHEMA_VERSION_SIZE_BYTES = 2;
    public static final int TIMESTAMP_OFFSET = 1;
    public static final int NEXT_LINK_OFFSET = 9;
    public static final int VALUE_SIZE_OFFSET = 15;
    public static final int SCHEMA_VERSION_OFFSET = 19;
    public static final int VALUE_OFFSET = 21;
    private final int partitionId;
    private long link;
    @Nullable
    private final HybridTimestamp timestamp;
    private final long nextLink;
    private final int valueSize;
    @IgniteToStringExclude
    @Nullable
    private final BinaryRow value;

    public RowVersion(int partitionId, long nextLink, @Nullable BinaryRow value) {
        this(partitionId, 0L, null, nextLink, value);
    }

    public RowVersion(int partitionId, HybridTimestamp commitTimestamp, long nextLink, @Nullable BinaryRow value) {
        this(partitionId, 0L, commitTimestamp, nextLink, value);
    }

    public RowVersion(int partitionId, long link, @Nullable HybridTimestamp timestamp, long nextLink, @Nullable BinaryRow value) {
        this.partitionId = partitionId;
        this.link(link);
        this.timestamp = timestamp;
        this.nextLink = nextLink;
        this.valueSize = value == null ? 0 : value.tupleSliceLength();
        this.value = value;
    }

    public RowVersion(int partitionId, long link, @Nullable HybridTimestamp timestamp, long nextLink, int valueSize) {
        this.partitionId = partitionId;
        this.link(link);
        this.timestamp = timestamp;
        this.nextLink = nextLink;
        this.valueSize = valueSize;
        this.value = null;
    }

    @Nullable
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public long nextLink() {
        return this.nextLink;
    }

    public int valueSize() {
        return this.valueSize;
    }

    @Nullable
    public BinaryRow value() {
        return this.value;
    }

    public boolean hasNextLink() {
        return this.nextLink != 0L;
    }

    boolean isTombstone() {
        return this.valueSize == 0;
    }

    boolean isUncommitted() {
        return this.timestamp == null;
    }

    boolean isCommitted() {
        return this.timestamp != null;
    }

    public void link(long link) {
        this.link = link;
    }

    public long link() {
        return this.link;
    }

    public int partition() {
        return this.partitionId;
    }

    public int size() {
        return this.headerSize() + this.valueSize;
    }

    public int headerSize() {
        return 21;
    }

    public void writeRowData(long pageAddr, int dataOff, int payloadSize, boolean newRow) {
        PageUtils.putShort((long)pageAddr, (int)dataOff, (short)((short)payloadSize));
        PageUtils.putByte((long)pageAddr, (int)((dataOff += 2) + 0), (byte)0);
        HybridTimestamps.writeTimestampToMemory(pageAddr, dataOff + 1, this.timestamp());
        PartitionlessLinks.writePartitionless((long)(pageAddr + (long)dataOff + 9L), (long)this.nextLink());
        PageUtils.putInt((long)pageAddr, (int)(dataOff + 15), (int)this.valueSize());
        if (this.value != null) {
            PageUtils.putShort((long)pageAddr, (int)(dataOff + 19), (short)((short)this.value.schemaVersion()));
            PageUtils.putByteBuffer((long)pageAddr, (int)(dataOff + 21), (ByteBuffer)this.value.tupleSlice());
        } else {
            PageUtils.putShort((long)pageAddr, (int)(dataOff + 19), (short)0);
        }
    }

    public void writeFragmentData(ByteBuffer pageBuf, int rowOff, int payloadSize) {
        int bufferSize;
        int bufferOffset;
        int headerSize = this.headerSize();
        if (rowOff == 0) {
            assert (headerSize <= payloadSize) : "Header must entirely fit in the first fragment, but header size is " + headerSize + " and payload size is " + payloadSize;
            pageBuf.put((byte)0);
            HybridTimestamps.writeTimestampToBuffer(pageBuf, this.timestamp());
            PartitionlessLinks.writeToBuffer((ByteBuffer)pageBuf, (long)this.nextLink());
            pageBuf.putInt(this.valueSize());
            pageBuf.putShort(this.value == null ? (short)0 : (short)this.value.schemaVersion());
            bufferOffset = 0;
            bufferSize = payloadSize - headerSize;
        } else {
            assert (rowOff >= headerSize);
            bufferOffset = rowOff - headerSize;
            bufferSize = payloadSize;
        }
        if (this.value != null) {
            Storable.putValueBufferIntoPage((ByteBuffer)pageBuf, (ByteBuffer)this.value.tupleSlice(), (int)bufferOffset, (int)bufferSize);
        }
    }

    public String toString() {
        return S.toString(RowVersion.class, (Object)this);
    }
}

