/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.disaster.system.message;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.disaster.system.message.ResetClusterMessage;
import org.apache.ignite.internal.disaster.system.message.ResetClusterMessageBuilder;
import org.apache.ignite.internal.disaster.system.message.SystemDisasterRecoveryMessagesFactory;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class ResetClusterMessageDeserializer
implements MessageDeserializer<ResetClusterMessage> {
    private final ResetClusterMessageBuilder msg;

    ResetClusterMessageDeserializer(SystemDisasterRecoveryMessagesFactory messageFactory) {
        this.msg = messageFactory.resetClusterMessage();
    }

    public Class<ResetClusterMessage> klass() {
        return ResetClusterMessage.class;
    }

    public ResetClusterMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readUuid("clusterId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.clusterId((UUID)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readString("clusterName");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.clusterName((String)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readString("conductor");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.conductor((String)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readSet("currentMetaStorageNodes", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.currentMetaStorageNodes((Set<String>)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readList("formerClusterIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.formerClusterIds((List<UUID>)tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readString("initialClusterConfiguration");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initialClusterConfiguration((String)tmp);
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readBoxedInt("metastorageReplicationFactor");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.metastorageReplicationFactor((Integer)tmp);
                reader.incrementState();
            }
            case 7: {
                Object tmp = reader.readSet("newCmgNodes", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.newCmgNodes((Set<String>)tmp);
                reader.incrementState();
            }
            case 8: {
                Object tmp = reader.readSet("participatingNodes", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.participatingNodes((Set<String>)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ResetClusterMessage.class);
    }
}

