/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.node;

import jakarta.inject.Inject;
import java.net.URL;
import org.apache.ignite.internal.cli.commands.ProfileMixin;
import org.apache.ignite.internal.cli.config.CliConfigKeys;
import org.apache.ignite.internal.cli.config.ConfigManager;
import org.apache.ignite.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite.internal.cli.core.converters.RestEndpointUrlConverter;
import picocli.CommandLine;

public class NodeUrlProfileMixin {
    @CommandLine.Option(names={"--url"}, description={"URL of a node that will be used as a communication endpoint. It can be any node URL. If not set, then the default URL from the profile settings will be used"}, converter={RestEndpointUrlConverter.class})
    private URL nodeUrl;
    @CommandLine.Mixin
    private ProfileMixin profileName;
    @Inject
    private ConfigManagerProvider configManagerProvider;

    public String getNodeUrl() {
        if (this.nodeUrl != null) {
            return this.nodeUrl.toString();
        }
        ConfigManager configManager = this.configManagerProvider.get();
        return configManager.getProperty(CliConfigKeys.CLUSTER_URL.value(), this.profileName.getProfileName());
    }
}

