/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.exception.handler;

import org.apache.ignite3.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.exception.handler.IgniteCliApiExceptionHandler;
import org.apache.ignite3.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import org.apache.ignite3.internal.cli.core.style.element.UiElements;
import org.apache.ignite3.rest.client.invoker.ApiException;

public class ClusterNotInitializedExceptionHandler
extends IgniteCliApiExceptionHandler {
    private final String header;
    private final String command;

    public ClusterNotInitializedExceptionHandler(String header, String command) {
        this.header = header;
        this.command = command;
    }

    @Override
    public int handle(ExceptionWriter err, IgniteCliApiException e) {
        ApiException apiException;
        if (e.getCause() instanceof ApiException && (apiException = (ApiException)e.getCause()).getCode() == 409) {
            err.write(ErrorUiComponent.builder().header(this.header, new UiElement[0]).details("Probably, you have not initialized the cluster, try to run %s command", UiElements.command(this.command)).verbose(apiException.getMessage(), new UiElement[0]).build().render());
            return 1;
        }
        return super.handle(err, e);
    }

    public static ClusterNotInitializedExceptionHandler createHandler(String message) {
        return new ClusterNotInitializedExceptionHandler(message, "ignite cluster init");
    }

    public static ClusterNotInitializedExceptionHandler createReplHandler(String message) {
        return new ClusterNotInitializedExceptionHandler(message, "cluster init");
    }
}

