/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage;

import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.raft.jraft.entity.LogId;

public class TermCache {
    private final int mask;
    private final long[] indexes;
    private final long[] terms;
    private int head = -1;
    private int tail;

    public TermCache(int capacity) {
        assert (IgniteUtils.isPow2(capacity)) : "Capacity must be a power of 2";
        this.mask = capacity - 1;
        this.indexes = new long[capacity];
        this.terms = new long[capacity];
    }

    public void append(LogId id) {
        if (this.isEmpty()) {
            this.head = 0;
            this.indexes[this.tail] = id.getIndex();
            this.terms[this.tail] = id.getTerm();
            return;
        }
        if (this.terms[this.tail] == id.getTerm()) {
            return;
        }
        this.tail = this.next(this.tail);
        this.indexes[this.tail] = id.getIndex();
        this.terms[this.tail] = id.getTerm();
        if (this.tail == this.head) {
            this.head = this.next(this.head);
        }
    }

    private int prev(int i) {
        return i - 1 & this.mask;
    }

    private int next(int i) {
        return i + 1 & this.mask;
    }

    private boolean isEmpty() {
        return this.head == -1;
    }

    private int findIndex(long idx) {
        int i = this.tail;
        while (i != this.head) {
            if (idx >= this.indexes[i]) {
                return i;
            }
            i = this.prev(i);
        }
        return this.head;
    }

    public long lookup(long idx) {
        if (this.isEmpty() || idx < this.indexes[this.head]) {
            return -1L;
        }
        return this.terms[this.findIndex(idx)];
    }

    public void reset() {
        this.head = -1;
        this.tail = 0;
    }

    public void truncateTail(long idx) {
        if (this.isEmpty() || idx < this.indexes[this.head]) {
            this.reset();
            return;
        }
        this.tail = this.findIndex(idx);
        if (this.indexes[this.tail] == idx) {
            if (this.head == this.tail) {
                this.reset();
            } else {
                this.tail = this.prev(this.tail);
            }
        }
    }
}

