/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.annotations.Marshallable;
import org.apache.ignite3.internal.network.annotations.Transferable;
import org.apache.ignite3.internal.tostring.IgniteStringifier;
import org.apache.ignite3.internal.tostring.SizeOnlyStringifier;
import org.apache.ignite3.raft.jraft.entity.RaftOutter;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.rpc.impl.SMThrowable;
import org.jetbrains.annotations.Nullable;

public final class RpcRequests {
    private RpcRequests() {
    }

    @Transferable(value=3016)
    public static interface CoalescedHeartbeatResponse
    extends Message {
        public Collection<Message> messages();
    }

    @Transferable(value=3015)
    public static interface CoalescedHeartbeatRequest
    extends Message {
        public Collection<AppendEntriesRequest> messages();
    }

    @Transferable(value=3013)
    public static interface ReadIndexResponse
    extends Message {
        public long index();

        public boolean success();
    }

    @Transferable(value=3012)
    public static interface ReadIndexRequest
    extends Message {
        public String groupId();

        @Nullable
        public String serverId();

        @IgniteStringifier(name="entriesList.size", value=SizeOnlyStringifier.class)
        @Nullable
        public List<ByteBuffer> entriesList();

        @Nullable
        public String peerId();
    }

    @Transferable(value=3011)
    public static interface GetFileResponse
    extends Message {
        public boolean eof();

        public long readSize();

        public ByteBuffer data();
    }

    @Transferable(value=3010)
    public static interface GetFileRequest
    extends Message {
        public long readerId();

        public String filename();

        public long count();

        public long offset();

        public boolean readPartly();
    }

    @Transferable(value=3009)
    public static interface AppendEntriesResponse
    extends ErrorResponse {
        public long term();

        public boolean success();

        public long lastLogIndex();

        @Nullable
        public HybridTimestamp timestamp();
    }

    @Transferable(value=3008)
    public static interface AppendEntriesRequest
    extends Message {
        public String groupId();

        public String serverId();

        public String peerId();

        public long term();

        public long prevLogTerm();

        public long prevLogIndex();

        @Nullable
        public Collection<RaftOutter.EntryMeta> entriesList();

        public long committedIndex();

        @Nullable
        public ByteBuffer data();

        @Nullable
        public HybridTimestamp timestamp();
    }

    @Transferable(value=3007)
    public static interface RequestVoteResponse
    extends Message {
        public long term();

        public boolean granted();
    }

    @Transferable(value=3006)
    public static interface RequestVoteRequest
    extends Message {
        public String groupId();

        public String serverId();

        public String peerId();

        public long term();

        public long lastLogTerm();

        public long lastLogIndex();

        public boolean preVote();
    }

    @Transferable(value=3005)
    public static interface TimeoutNowResponse
    extends Message {
        public long term();

        public boolean success();
    }

    @Transferable(value=3004)
    public static interface TimeoutNowRequest
    extends Message {
        public String groupId();

        public String serverId();

        public String peerId();

        public long term();

        public HybridTimestamp timestamp();
    }

    @Transferable(value=3003)
    public static interface InstallSnapshotResponse
    extends Message {
        public long term();

        public boolean success();
    }

    @Transferable(value=3002)
    public static interface InstallSnapshotRequest
    extends Message {
        public String groupId();

        public String serverId();

        public String peerId();

        public long term();

        public RaftOutter.SnapshotMeta meta();

        public String uri();
    }

    @Transferable(value=3014)
    public static interface SMErrorResponse
    extends Message {
        @Marshallable
        public SMThrowable error();
    }

    @Transferable(value=3001)
    public static interface ErrorResponse
    extends Message {
        public int errorCode();

        @Nullable
        public String errorMsg();

        @Nullable
        public String leaderId();

        @Nullable
        public Long maxObservableSafeTimeViolatedValue();
    }

    @Transferable(value=3000)
    public static interface PingRequest
    extends Message {
        public long sendTimestamp();
    }
}

