/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

public final class ProtocolVersion
implements Comparable<ProtocolVersion> {
    public static final ProtocolVersion V1_7_0 = new ProtocolVersion(1, 7, 0);
    public static final ProtocolVersion V1_6_0 = new ProtocolVersion(1, 6, 0);
    public static final ProtocolVersion V1_5_0 = new ProtocolVersion(1, 5, 0);
    public static final ProtocolVersion V1_4_0 = new ProtocolVersion(1, 4, 0);
    public static final ProtocolVersion V1_3_0 = new ProtocolVersion(1, 3, 0);
    public static final ProtocolVersion V1_2_0 = new ProtocolVersion(1, 2, 0);
    public static final ProtocolVersion V1_1_0 = new ProtocolVersion(1, 1, 0);
    public static final ProtocolVersion V1_0_0 = new ProtocolVersion(1, 0, 0);
    public static final ProtocolVersion LATEST_VER = V1_7_0;
    private final short major;
    private final short minor;
    private final short patch;

    public ProtocolVersion(short major, short minor, short patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public short major() {
        return this.major;
    }

    public short minor() {
        return this.minor;
    }

    public short patch() {
        return this.patch;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProtocolVersion)) {
            return false;
        }
        ProtocolVersion other = (ProtocolVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    public int hashCode() {
        int res = 11;
        res = 31 * res + this.major;
        res = 31 * res + this.minor;
        res = 31 * res + this.patch;
        return res;
    }

    @Override
    public int compareTo(ProtocolVersion other) {
        int diff = this.major - other.major;
        if (diff != 0) {
            return diff;
        }
        diff = this.minor - other.minor;
        if (diff != 0) {
            return diff;
        }
        return this.patch - other.patch;
    }

    public String toString() {
        return String.format("%s.%s.%s", this.major, this.minor, this.patch);
    }
}

