/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.security.AccessControlException;
import java.util.UUID;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListenerException;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.internal.processors.security.AbstractSecurityAwareExternalizable;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.sandbox.IgniteSandbox;

public class SecurityAwareFilter<K, V>
extends AbstractSecurityAwareExternalizable<CacheEntryEventFilter<K, V>>
implements CacheEntryEventSerializableFilter<K, V> {
    private static final long serialVersionUID = 0L;

    public SecurityAwareFilter() {
    }

    public SecurityAwareFilter(UUID subjectId, CacheEntryEventFilter<K, V> original) {
        super(subjectId, original);
    }

    public boolean evaluate(CacheEntryEvent<? extends K, ? extends V> evt) throws CacheEntryListenerException {
        if (this.original == null) {
            return true;
        }
        IgniteSecurity security = this.ignite.context().security();
        OperationSecurityContext c = security.withContext(this.subjectId);
        try {
            boolean bl;
            IgniteSandbox sandbox = security.sandbox();
            boolean bl2 = bl = sandbox.enabled() ? sandbox.execute(() -> ((CacheEntryEventFilter)this.original).evaluate(evt)).booleanValue() : ((CacheEntryEventFilter)this.original).evaluate(evt);
            if (c != null) {
                c.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AccessControlException e) {
                this.logAccessDeniedMessage(e);
                throw e;
            }
        }
    }
}

