/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.memory;

import org.apache.ignite.internal.processors.platform.memory.PlatformBigEndianInputStreamImpl;
import org.apache.ignite.internal.processors.platform.memory.PlatformBigEndianOutputStreamImpl;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStream;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStreamImpl;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryUtils;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStreamImpl;
import org.apache.ignite.internal.util.GridUnsafe;

public abstract class PlatformAbstractMemory
implements PlatformMemory {
    private static final StreamFactory STREAM_FACTORY = GridUnsafe.BIG_ENDIAN ? new BigEndianStreamFactory() : new LittleEndianStreamFactory();
    protected long memPtr;

    protected PlatformAbstractMemory(long memPtr) {
        this.memPtr = memPtr;
    }

    @Override
    public PlatformInputStream input() {
        return STREAM_FACTORY.createInput(this);
    }

    @Override
    public PlatformOutputStream output() {
        return STREAM_FACTORY.createOutput(this);
    }

    @Override
    public long pointer() {
        return this.memPtr;
    }

    @Override
    public long data() {
        return PlatformMemoryUtils.data(this.memPtr);
    }

    @Override
    public int capacity() {
        return PlatformMemoryUtils.capacity(this.memPtr);
    }

    @Override
    public int length() {
        return PlatformMemoryUtils.length(this.memPtr);
    }

    private static class BigEndianStreamFactory
    implements StreamFactory {
        private BigEndianStreamFactory() {
        }

        @Override
        public PlatformInputStreamImpl createInput(PlatformMemory mem) {
            return new PlatformBigEndianInputStreamImpl(mem);
        }

        @Override
        public PlatformOutputStreamImpl createOutput(PlatformMemory mem) {
            return new PlatformBigEndianOutputStreamImpl(mem);
        }
    }

    private static class LittleEndianStreamFactory
    implements StreamFactory {
        private LittleEndianStreamFactory() {
        }

        @Override
        public PlatformInputStreamImpl createInput(PlatformMemory mem) {
            return new PlatformInputStreamImpl(mem);
        }

        @Override
        public PlatformOutputStreamImpl createOutput(PlatformMemory mem) {
            return new PlatformOutputStreamImpl(mem);
        }
    }

    private static interface StreamFactory {
        public PlatformInputStreamImpl createInput(PlatformMemory var1);

        public PlatformOutputStreamImpl createOutput(PlatformMemory var1);
    }
}

