/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey.internal;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.transport.api.IoThreadFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.glassfish.jersey.message.internal.EntityInputStream;
import org.glassfish.jersey.message.internal.ReaderInterceptorExecutor;

public final class BufferPublisherInputStream
extends InputStream {
    private static final InputStream EMPTY_INPUT_STREAM = new InputStream(){

        @Override
        public int read() {
            return -1;
        }
    };
    private InputStream inputStream = EMPTY_INPUT_STREAM;
    private Publisher<Buffer> publisher;
    private final int queueCapacity;

    public BufferPublisherInputStream(Publisher<Buffer> publisher, int queueCapacity) {
        this.publisher = Objects.requireNonNull(publisher);
        this.queueCapacity = queueCapacity;
    }

    @Override
    public int read() throws IOException {
        this.publisherToInputStream();
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.publisherToInputStream();
        return this.inputStream.read(b, off, len);
    }

    public void offloadSourcePublisher(HttpExecutionStrategy executionStrategy, io.servicetalk.concurrent.api.Executor executor) {
        if (this.inputStream != EMPTY_INPUT_STREAM) {
            throw new IllegalStateException("Can't offload source publisher because it is consumed via InputStream");
        }
        this.publisher = executionStrategy.isMetadataReceiveOffloaded() || executionStrategy.isDataReceiveOffloaded() ? this.publisher.publishOn((Executor)executor, IoThreadFactory.IoThread::currentThreadIsIoThread) : this.publisher;
    }

    private Publisher<Buffer> bufferPublisher() {
        if (this.inputStream != EMPTY_INPUT_STREAM) {
            throw new IllegalStateException("Publisher is being consumed via InputStream");
        }
        return this.publisher;
    }

    private void publisherToInputStream() {
        if (this.inputStream == EMPTY_INPUT_STREAM) {
            this.inputStream = this.publisher.toInputStream(BufferPublisherInputStream::getBytes, this.queueCapacity);
        }
    }

    public static <T> T handleEntityStream(InputStream entityStream, BufferAllocator allocator, BiFunction<Publisher<Buffer>, BufferAllocator, T> bufferPublisherHandler, BiFunction<InputStream, BufferAllocator, T> inputStreamHandler) {
        Objects.requireNonNull(allocator);
        Objects.requireNonNull(bufferPublisherHandler);
        Objects.requireNonNull(inputStreamHandler);
        EntityInputStream eis = (EntityInputStream)ReaderInterceptorExecutor.closeableInputStream((InputStream)Objects.requireNonNull(entityStream));
        InputStream wrappedStream = eis.getWrappedStream();
        if (wrappedStream instanceof BufferPublisherInputStream) {
            return bufferPublisherHandler.apply(((BufferPublisherInputStream)wrappedStream).bufferPublisher(), allocator);
        }
        return inputStreamHandler.apply(wrappedStream, allocator);
    }

    @Nullable
    private static byte[] getBytes(Buffer content) {
        int readableBytes = content.readableBytes();
        if (readableBytes == 0) {
            return null;
        }
        if (content.hasArray() && content.arrayOffset() == 0 && content.array().length == readableBytes) {
            return content.array();
        }
        byte[] bytes = new byte[readableBytes];
        content.readBytes(bytes);
        return bytes;
    }
}

