/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.nga.style;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.extension.nga.style.IconRow;
import mil.nga.sf.GeometryType;
import mil.nga.sf.util.GeometryUtils;

public class Icons {
    private IconRow defaultIcon;
    private Map<GeometryType, IconRow> icons = new HashMap<GeometryType, IconRow>();
    private boolean tableIcons;

    public Icons() {
        this(false);
    }

    public Icons(boolean tableIcons) {
        this.tableIcons = tableIcons;
    }

    public void setDefault(IconRow iconRow) {
        this.setIcon(iconRow, null);
    }

    public void setIcon(IconRow iconRow, GeometryType geometryType) {
        if (iconRow != null) {
            iconRow.setTableIcon(this.tableIcons);
        }
        if (geometryType != null) {
            if (iconRow != null) {
                this.icons.put(geometryType, iconRow);
            } else {
                this.icons.remove(geometryType);
            }
        } else {
            this.defaultIcon = iconRow;
        }
    }

    public IconRow getDefault() {
        return this.defaultIcon;
    }

    public Map<GeometryType, IconRow> getIcons() {
        return Collections.unmodifiableMap(this.icons);
    }

    public IconRow getIcon() {
        return this.getIcon(null);
    }

    public IconRow getIcon(GeometryType geometryType) {
        IconRow iconRow = null;
        if (geometryType != null && !this.icons.isEmpty()) {
            GeometryType type;
            List geometryTypes = GeometryUtils.parentHierarchy((GeometryType)geometryType);
            geometryTypes.add(0, geometryType);
            Iterator iterator = geometryTypes.iterator();
            while (iterator.hasNext() && (iconRow = this.icons.get(type = (GeometryType)iterator.next())) == null) {
            }
        }
        if (iconRow == null) {
            iconRow = this.defaultIcon;
        }
        if (iconRow == null && geometryType == null && this.icons.size() == 1) {
            iconRow = this.icons.values().iterator().next();
        }
        return iconRow;
    }

    public boolean isEmpty() {
        return this.defaultIcon == null && this.icons.isEmpty();
    }

    public boolean hasDefault() {
        return this.defaultIcon != null;
    }

    public boolean isTableIcons() {
        return this.tableIcons;
    }

    public void setTableIcons(boolean tableIcons) {
        this.tableIcons = tableIcons;
    }
}

