/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import java.util.function.Predicate;

final class ConditionalHttpServiceFilter
extends StreamingHttpServiceFilter {
    private final Predicate<StreamingHttpRequest> predicate;
    private final StreamingHttpServiceFilter predicatedFilter;
    private final CompositeCloseable closeable;

    ConditionalHttpServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilter predicatedFilter, StreamingHttpService service) {
        super(service);
        this.predicate = predicate;
        this.predicatedFilter = predicatedFilter;
        this.closeable = AsyncCloseables.newCompositeCloseable();
        this.closeable.append((AsyncCloseable)predicatedFilter);
        this.closeable.append((AsyncCloseable)service);
    }

    public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest req, StreamingHttpResponseFactory resFactory) {
        if (this.predicate.test(req)) {
            return this.predicatedFilter.handle(ctx, req, resFactory);
        }
        return this.delegate().handle(ctx, req, resFactory);
    }

    public Completable closeAsync() {
        return this.closeable.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.closeable.closeAsyncGracefully();
    }
}

