/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.DelegatingConnectionFactory;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.netty.GlobalDnsServiceDiscoverer;
import io.servicetalk.transport.api.ConnectExecutionStrategy;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.TransportObserver;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class ResolvingConnectionFactoryFilter<U, R>
implements ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> {
    private final Function<R, U> toUnresolvedAddressMapper;
    private final ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> serviceDiscoverer;

    ResolvingConnectionFactoryFilter(Function<R, U> toUnresolvedAddressMapper, ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> serviceDiscoverer) {
        this.toUnresolvedAddressMapper = Objects.requireNonNull(toUnresolvedAddressMapper);
        this.serviceDiscoverer = Objects.requireNonNull(serviceDiscoverer);
    }

    public ConnectionFactory<R, FilterableStreamingHttpConnection> create(ConnectionFactory<R, FilterableStreamingHttpConnection> original) {
        return new DelegatingConnectionFactory<R, FilterableStreamingHttpConnection>(original){

            public Single<FilterableStreamingHttpConnection> newConnection(R address, @Nullable ContextMap context, @Nullable TransportObserver observer) {
                Object unresolvedAddress = ResolvingConnectionFactoryFilter.this.toUnresolvedAddressMapper.apply(address);
                return ResolvingConnectionFactoryFilter.this.serviceDiscoverer.discover(unresolvedAddress).takeAtMost(1L).firstOrError().flatMap(resolvedAddresses -> {
                    ServiceDiscovererEvent resolved;
                    if (resolvedAddresses.isEmpty()) {
                        resolved = null;
                    } else if (resolvedAddresses.size() == 1) {
                        ServiceDiscovererEvent serviceDiscovererEvent = resolved = resolvedAddresses instanceof List ? (ServiceDiscovererEvent)((List)resolvedAddresses).get(0) : (ServiceDiscovererEvent)resolvedAddresses.stream().findFirst().orElse(null);
                        if (resolved != null && !ServiceDiscovererEvent.Status.AVAILABLE.equals((Object)resolved.status())) {
                            resolved = null;
                        }
                    } else {
                        List list = resolvedAddresses.stream().filter(event -> ServiceDiscovererEvent.Status.AVAILABLE.equals((Object)event.status())).collect(Collectors.toList());
                        resolved = list.isEmpty() ? null : (ServiceDiscovererEvent)list.get(ThreadLocalRandom.current().nextInt(0, list.size()));
                    }
                    return (resolved == null ? ResolvingConnectionFactoryFilter.this.unknownHostException(unresolvedAddress, resolvedAddresses) : this.delegate().newConnection(resolved.address(), context, observer)).shareContextOnSubscribe();
                });
            }
        };
    }

    private Single<FilterableStreamingHttpConnection> unknownHostException(U unresolvedAddress, Collection<? extends ServiceDiscovererEvent<R>> resolvedAddresses) {
        return Single.failed((Throwable)new UnknownHostException(this.serviceDiscoverer + " didn't return any available record for " + unresolvedAddress + ", resolved addresses: " + resolvedAddresses));
    }

    public ExecutionStrategy requiredOffloads() {
        return ConnectExecutionStrategy.offloadNone();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{toUnresolvedAddressMapper=" + this.toUnresolvedAddressMapper + ", serviceDiscoverer=" + this.serviceDiscoverer + '}';
    }

    static ResolvingConnectionFactoryFilter<HostAndPort, InetSocketAddress> withGlobalDnsServiceDiscoverer() {
        return DefaultResolvingConnectionFactoryFilterInitializer.INSTANCE;
    }

    private static final class DefaultResolvingConnectionFactoryFilterInitializer {
        static final ResolvingConnectionFactoryFilter<HostAndPort, InetSocketAddress> INSTANCE = new ResolvingConnectionFactoryFilter<HostAndPort, InetSocketAddress>(HostAndPort::of, GlobalDnsServiceDiscoverer.globalDnsServiceDiscoverer());

        private DefaultResolvingConnectionFactoryFilterInitializer() {
        }
    }
}

