/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.ogcapi.model.Link;

@JsonTypeName(value="landingPage")
public class LandingPage {
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private String attribution;
    @Valid
    private List<Link> links = new ArrayList<Link>();

    public LandingPage title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="While a title is not required, implementors are strongly advised to include one.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public LandingPage description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public LandingPage attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @ApiModelProperty(value="The `attribution` should be short and intended for presentation to a user, for example, in a corner of a map. Parts of the text can be links to other resources if additional information is needed. The string can include HTML markup.")
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    @JsonProperty(value="attribution")
    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public LandingPage links(List<Link> links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="links")
    @NotNull
    public List<Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public LandingPage addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    public LandingPage removeLinksItem(Link linksItem) {
        if (linksItem != null && this.links != null) {
            this.links.remove(linksItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LandingPage landingPage = (LandingPage)o;
        return Objects.equals(this.title, landingPage.title) && Objects.equals(this.description, landingPage.description) && Objects.equals(this.attribution, landingPage.attribution) && Objects.equals(this.links, landingPage.links);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.attribution, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LandingPage {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString(this.attribution)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

