/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.contents.ContentsDataType;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureColumns;
import mil.nga.geopackage.user.UserTable;

public class FeatureTable
extends UserTable<FeatureColumn> {
    public FeatureTable(GeometryColumns geometryColumns, List<FeatureColumn> columns) {
        this(geometryColumns.getTableName(), geometryColumns.getColumnName(), columns);
    }

    public FeatureTable(String tableName, List<FeatureColumn> columns) {
        this(tableName, null, columns);
    }

    public FeatureTable(String tableName, String geometryColumn, List<FeatureColumn> columns) {
        super(new FeatureColumns(tableName, geometryColumn, columns));
    }

    public FeatureTable(FeatureTable featureTable) {
        super(featureTable);
    }

    public FeatureTable copy() {
        return new FeatureTable(this);
    }

    @Override
    public String getDataType() {
        return this.getDataType(ContentsDataType.FEATURES.getName());
    }

    public FeatureColumns getUserColumns() {
        return (FeatureColumns)super.getUserColumns();
    }

    public FeatureColumns createUserColumns(List<FeatureColumn> columns) {
        return new FeatureColumns(this.getTableName(), this.getGeometryColumnName(), columns, true);
    }

    public int getGeometryColumnIndex() {
        return this.getUserColumns().getGeometryIndex();
    }

    public FeatureColumn getGeometryColumn() {
        return this.getUserColumns().getGeometryColumn();
    }

    public String getGeometryColumnName() {
        return this.getUserColumns().getGeometryColumnName();
    }

    public String[] getIdAndGeometryColumnNames() {
        return new String[]{this.getPkColumnName(), this.getGeometryColumnName()};
    }

    @Override
    protected void validateContents(Contents contents) {
        if (!contents.isFeaturesTypeOrUnknown()) {
            throw new GeoPackageException("The " + Contents.class.getSimpleName() + " of a " + FeatureTable.class.getSimpleName() + " must have a data type of " + ContentsDataType.FEATURES.getName() + ". actual type: " + contents.getDataTypeName());
        }
    }
}

