/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.reproject;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.reproject.TileReprojectionOptimize;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;

public class WebMercatorOptimize
extends TileReprojectionOptimize {
    public static WebMercatorOptimize create() {
        return new WebMercatorOptimize();
    }

    public static WebMercatorOptimize createWorld() {
        return new WebMercatorOptimize(true);
    }

    public WebMercatorOptimize() {
    }

    public WebMercatorOptimize(boolean world) {
        super(world);
    }

    @Override
    public Projection getProjection() {
        return ProjectionFactory.getProjection((long)3857L);
    }

    @Override
    public TileGrid getTileGrid() {
        return new TileGrid(0L, 0L, 0L, 0L);
    }

    @Override
    public BoundingBox getBoundingBox() {
        return BoundingBox.worldWebMercator();
    }

    @Override
    public TileGrid getTileGrid(BoundingBox boundingBox, long zoom) {
        return TileBoundingBoxUtils.getTileGrid(boundingBox, (int)zoom);
    }

    @Override
    public BoundingBox getBoundingBox(TileGrid tileGrid, long zoom) {
        return TileBoundingBoxUtils.getWebMercatorBoundingBox(tileGrid, (int)zoom);
    }
}

