/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.UriUtils;

enum UriComponentType {
    USER_INFO{

        @Override
        boolean isValid(byte b) {
            return UriUtils.isBitSet(b, UriUtils.USERINFO_LMASK, UriUtils.USERINFO_HMASK);
        }
    }
    ,
    PATH{

        @Override
        boolean isValid(byte b) {
            return UriUtils.isBitSet(b, UriUtils.PATH_LMASK, UriUtils.PATH_HMASK);
        }
    }
    ,
    PATH_SEGMENT{

        @Override
        boolean isValid(byte b) {
            return UriUtils.isBitSet(b, UriUtils.PATH_SEGMENT_LMASK, UriUtils.PATH_SEGMENT_HMASK);
        }
    }
    ,
    QUERY{

        @Override
        boolean isValid(byte b) {
            return UriUtils.isBitSet(b, UriUtils.QUERY_LMASK, UriUtils.QUERY_HMASK);
        }
    }
    ,
    QUERY_VALUE{

        @Override
        boolean isValid(byte b) {
            return UriUtils.isBitSet(b, UriUtils.QUERY_VALUE_LMASK, UriUtils.QUERY_VALUE_HMASK);
        }
    }
    ,
    FRAGMENT{

        @Override
        boolean isValid(byte b) {
            return UriUtils.isBitSet(b, UriUtils.FRAGMENT_LMASK, UriUtils.FRAGMENT_HMASK);
        }
    }
    ,
    HOST_NON_IP{

        @Override
        boolean isValid(byte b) {
            return UriUtils.isBitSet(b, UriUtils.HOST_NON_IP_LMASK, UriUtils.HOST_NON_IP_HMASK);
        }
    };


    abstract boolean isValid(byte var1);
}

