/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SubmitCompletable;
import io.servicetalk.concurrent.api.SubmitSingle;
import io.servicetalk.concurrent.api.SubmitSupplierCompletable;
import io.servicetalk.concurrent.api.SubmitSupplierSingle;
import io.servicetalk.concurrent.api.TimerCompletable;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface Executor
extends io.servicetalk.concurrent.Executor,
ListenableAsyncCloseable {
    default public Completable timer(long delay, TimeUnit unit) {
        return new TimerCompletable(delay, unit, this);
    }

    default public Completable timer(Duration delay) {
        return new TimerCompletable(delay, this);
    }

    default public Completable submit(Runnable runnable) {
        return new SubmitCompletable(runnable, this);
    }

    default public Completable submitRunnable(Supplier<Runnable> runnableSupplier) {
        return new SubmitSupplierCompletable(runnableSupplier, this);
    }

    default public <T> Single<T> submit(Callable<? extends T> callable) {
        return new SubmitSingle<T>(callable, this);
    }

    default public <T> Single<T> submitCallable(Supplier<? extends Callable<? extends T>> callableSupplier) {
        return new SubmitSupplierSingle(callableSupplier, this);
    }
}

