/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.router.jersey.Context;
import io.servicetalk.http.router.jersey.DefaultContainer;
import io.servicetalk.http.router.jersey.DefaultContainerResponseWriter;
import io.servicetalk.http.router.jersey.JerseyRouteExecutionStrategyUtils;
import io.servicetalk.http.router.jersey.RouteStrategiesConfig;
import io.servicetalk.http.router.jersey.ServiceTalkFeature;
import io.servicetalk.http.router.jersey.internal.BufferPublisherInputStream;
import io.servicetalk.http.router.jersey.internal.RequestProperties;
import io.servicetalk.router.api.RouteExecutionStrategyFactory;
import io.servicetalk.transport.api.ConnectionContext;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.Principal;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;

final class DefaultJerseyStreamingHttpRouter
implements StreamingHttpService {
    private static final SecurityContext UNAUTHENTICATED_SECURITY_CONTEXT = new SecurityContext(){

        @Nullable
        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        @Nullable
        public String getAuthenticationScheme() {
            return null;
        }
    };
    private final ApplicationHandler applicationHandler;
    private final int publisherInputStreamQueueCapacity;
    private final BiFunction<ConnectionContext, HttpRequestMetaData, String> baseUriFunction;
    private final Container container;

    DefaultJerseyStreamingHttpRouter(Application application, int publisherInputStreamQueueCapacity, BiFunction<ConnectionContext, HttpRequestMetaData, String> baseUriFunction, RouteExecutionStrategyFactory<HttpExecutionStrategy> strategyFactory) {
        this(new ApplicationHandler(application), publisherInputStreamQueueCapacity, baseUriFunction, strategyFactory);
    }

    DefaultJerseyStreamingHttpRouter(Class<? extends Application> applicationClass, int publisherInputStreamQueueCapacity, BiFunction<ConnectionContext, HttpRequestMetaData, String> baseUriFunction, RouteExecutionStrategyFactory<HttpExecutionStrategy> strategyFactory) {
        this(new ApplicationHandler(applicationClass), publisherInputStreamQueueCapacity, baseUriFunction, strategyFactory);
    }

    private DefaultJerseyStreamingHttpRouter(ApplicationHandler applicationHandler, int publisherInputStreamQueueCapacity, BiFunction<ConnectionContext, HttpRequestMetaData, String> baseUriFunction, RouteExecutionStrategyFactory<HttpExecutionStrategy> strategyFactory) {
        if (!applicationHandler.getConfiguration().isEnabled(ServiceTalkFeature.class)) {
            throw new IllegalStateException("The " + ServiceTalkFeature.class.getSimpleName() + " needs to be enabled for this application.");
        }
        final RouteStrategiesConfig routeStrategiesConfig = JerseyRouteExecutionStrategyUtils.validateRouteStrategies(applicationHandler, strategyFactory);
        this.applicationHandler = applicationHandler;
        this.publisherInputStreamQueueCapacity = publisherInputStreamQueueCapacity;
        this.baseUriFunction = Objects.requireNonNull(baseUriFunction);
        applicationHandler.getInjectionManager().register((Binder)new AbstractBinder(){

            protected void configure() {
                ((InstanceBinding)this.bind(routeStrategiesConfig).to(RouteStrategiesConfig.class)).proxy(false);
            }
        });
        this.container = new DefaultContainer(applicationHandler);
        applicationHandler.onStartup(this.container);
    }

    Configuration configuration() {
        return this.applicationHandler.getConfiguration();
    }

    public Completable closeAsync() {
        return Completable.defer(() -> {
            try {
                this.applicationHandler.onShutdown(this.container);
                return Completable.completed();
            }
            catch (Throwable t) {
                return Completable.failed((Throwable)t);
            }
        });
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadAll();
    }

    public Single<StreamingHttpResponse> handle(final HttpServiceContext serviceCtx, final StreamingHttpRequest req, final StreamingHttpResponseFactory factory) {
        return new SubscribableSingle<StreamingHttpResponse>(){

            protected void handleSubscribe(SingleSource.Subscriber<? super StreamingHttpResponse> subscriber) {
                DelayedCancellable delayedCancellable = new DelayedCancellable();
                DuplicateTerminateDetectorSingle dupSub = new DuplicateTerminateDetectorSingle(subscriber);
                try {
                    dupSub.onSubscribe((Cancellable)delayedCancellable);
                }
                catch (Throwable cause) {
                    SubscriberUtils.handleExceptionFromOnSubscribe(dupSub, (Throwable)cause);
                    return;
                }
                try {
                    DefaultJerseyStreamingHttpRouter.this.handle0(serviceCtx, req, factory, (SingleSource.Subscriber<? super StreamingHttpResponse>)dupSub, delayedCancellable);
                }
                catch (Throwable t) {
                    SubscriberUtils.safeOnError(dupSub, (Throwable)t);
                }
            }
        };
    }

    private void handle0(HttpServiceContext serviceCtx, StreamingHttpRequest req, StreamingHttpResponseFactory factory, SingleSource.Subscriber<? super StreamingHttpResponse> subscriber, DelayedCancellable delayedCancellable) {
        URI requestURI;
        URI baseURI;
        CharSequence baseUri = this.baseUriFunction.apply((ConnectionContext)serviceCtx, (HttpRequestMetaData)req);
        String requestTarget = req.requestTarget();
        StringBuilder requestUriBuilder = new StringBuilder(baseUri.length() + requestTarget.length()).append(baseUri);
        assert (baseUri.length() == 0 || baseUri.charAt(baseUri.length() - 1) == '/');
        if (requestTarget.length() > 0 && requestTarget.charAt(0) == '/') {
            requestUriBuilder.append(requestTarget, 1, requestTarget.length());
        } else {
            requestUriBuilder.append((CharSequence)requestTarget);
        }
        try {
            baseURI = URI.create(baseUri.toString());
            requestURI = URI.create(requestUriBuilder.toString());
        }
        catch (IllegalArgumentException cause) {
            Buffer message = serviceCtx.executionContext().bufferAllocator().fromAscii((CharSequence)cause.getMessage());
            StreamingHttpResponse response = factory.badRequest().payloadBody(Publisher.from((Object)message));
            response.headers().set(HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(message.readableBytes()));
            response.headers().set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.TEXT_PLAIN);
            subscriber.onSuccess((Object)response);
            return;
        }
        CloseSignalHandoffAbleContainerRequest containerRequest = new CloseSignalHandoffAbleContainerRequest(baseURI, requestURI, req.method().name(), UNAUTHENTICATED_SECURITY_CONTEXT, (PropertiesDelegate)new MapPropertiesDelegate(), (Configuration)new ResourceConfig());
        req.headers().forEach(h -> containerRequest.getHeaders().add((Object)((CharSequence)h.getKey()).toString(), (Object)((CharSequence)h.getValue()).toString()));
        BufferPublisherInputStream entityStream = new BufferPublisherInputStream(req.payloadBody(), this.publisherInputStreamQueueCapacity);
        containerRequest.setEntityStream((InputStream)entityStream);
        RequestProperties.initRequestProperties((BufferPublisherInputStream)entityStream, (ContainerRequestContext)containerRequest);
        DefaultContainerResponseWriter responseWriter = new DefaultContainerResponseWriter(containerRequest, req.version(), serviceCtx, factory, subscriber);
        containerRequest.setWriter(responseWriter);
        containerRequest.setRequestScopedInitializer(injectionManager -> {
            ((Ref)injectionManager.getInstance(Context.CONNECTION_CONTEXT_REF_TYPE)).set((Object)serviceCtx);
            ((Ref)injectionManager.getInstance(Context.HTTP_REQUEST_REF_TYPE)).set((Object)req);
        });
        delayedCancellable.delayedCancellable(responseWriter::dispose);
        this.applicationHandler.handle((ContainerRequest)containerRequest);
    }

    private static final class DuplicateTerminateDetectorSingle<T>
    implements SingleSource.Subscriber<T> {
        private static final AtomicIntegerFieldUpdater<DuplicateTerminateDetectorSingle> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(DuplicateTerminateDetectorSingle.class, "done");
        private final SingleSource.Subscriber<T> delegate;
        private volatile int done;

        private DuplicateTerminateDetectorSingle(SingleSource.Subscriber<T> delegate) {
            this.delegate = delegate;
        }

        public void onSubscribe(Cancellable cancellable) {
            this.delegate.onSubscribe(cancellable);
        }

        public void onSuccess(@Nullable T result) {
            if (doneUpdater.compareAndSet(this, 0, 1)) {
                this.delegate.onSuccess(result);
            }
        }

        public void onError(Throwable t) {
            if (doneUpdater.compareAndSet(this, 0, 1)) {
                this.delegate.onError(t);
            }
        }
    }

    private static final class CloseSignalHandoffAbleContainerRequest
    extends ContainerRequest {
        private static final AtomicReferenceFieldUpdater<CloseSignalHandoffAbleContainerRequest, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(CloseSignalHandoffAbleContainerRequest.class, State.class, "state");
        private volatile State state = State.INIT;

        private CloseSignalHandoffAbleContainerRequest(URI baseUri, URI requestUri, String httpMethod, SecurityContext securityContext, PropertiesDelegate propertiesDelegate, Configuration configuration) {
            super(baseUri, requestUri, httpMethod, securityContext, propertiesDelegate, configuration);
        }

        public <T> T readEntity(Class<T> rawType) {
            return (T)this.readEntity(rawType, this.getPropertiesDelegate());
        }

        public <T> T readEntity(Class<T> rawType, Annotation[] annotations) {
            return (T)this.readEntity(rawType, annotations, this.getPropertiesDelegate());
        }

        public <T> T readEntity(Class<T> rawType, Type type) {
            return (T)this.readEntity(rawType, type, this.getPropertiesDelegate());
        }

        public <T> T readEntity(Class<T> rawType, Type type, Annotation[] annotations) {
            return this.readEntity(rawType, type, annotations, this.getPropertiesDelegate());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T readEntity(Class<T> rawType, Type type, Annotation[] annotations, PropertiesDelegate propertiesDelegate) {
            boolean reentry;
            State prevState = this.state;
            boolean bl = reentry = prevState == State.READING;
            if (reentry || stateUpdater.compareAndSet(this, State.INIT, State.READING)) {
                try {
                    Object object = super.readEntity(rawType, type, annotations, propertiesDelegate);
                    return (T)object;
                }
                finally {
                    if (!reentry && !stateUpdater.compareAndSet(this, State.READING, State.INIT)) {
                        this.close0();
                    }
                }
            }
            throw new IllegalStateException(LocalizationMessages.ERROR_ENTITY_STREAM_CLOSED());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean bufferEntity() throws ProcessingException {
            boolean reentry;
            State prevState = this.state;
            boolean bl = reentry = prevState == State.READING;
            if (reentry || stateUpdater.compareAndSet(this, State.INIT, State.READING)) {
                try {
                    boolean bl2 = super.bufferEntity();
                    return bl2;
                }
                finally {
                    if (!reentry && !stateUpdater.compareAndSet(this, State.READING, State.INIT)) {
                        this.close0();
                    }
                }
            }
            throw new IllegalStateException(LocalizationMessages.ERROR_ENTITY_STREAM_CLOSED());
        }

        public boolean hasEntity() {
            if (this.state == State.CLOSED) {
                throw new IllegalStateException(LocalizationMessages.ERROR_ENTITY_STREAM_CLOSED());
            }
            return super.hasEntity();
        }

        public InputStream getEntityStream() {
            if (this.state == State.CLOSED) {
                throw new IllegalStateException(LocalizationMessages.ERROR_ENTITY_STREAM_CLOSED());
            }
            return super.getEntityStream();
        }

        public void close() {
            State prevState = stateUpdater.getAndSet(this, State.PENDING_CLOSE);
            if (prevState == State.INIT) {
                this.close0();
            }
        }

        private void close0() {
            this.state = State.CLOSED;
            super.close();
        }

        private static enum State {
            INIT,
            READING,
            PENDING_CLOSE,
            CLOSED;

        }
    }
}

