/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.opencensus.stats;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.ratis.thirdparty.io.opencensus.common.Functions;
import org.apache.ratis.thirdparty.io.opencensus.common.Timestamp;
import org.apache.ratis.thirdparty.io.opencensus.internal.Utils;
import org.apache.ratis.thirdparty.io.opencensus.stats.Measure;
import org.apache.ratis.thirdparty.io.opencensus.stats.MeasureMap;
import org.apache.ratis.thirdparty.io.opencensus.stats.StatsCollectionState;
import org.apache.ratis.thirdparty.io.opencensus.stats.StatsComponent;
import org.apache.ratis.thirdparty.io.opencensus.stats.StatsRecorder;
import org.apache.ratis.thirdparty.io.opencensus.stats.View;
import org.apache.ratis.thirdparty.io.opencensus.stats.ViewData;
import org.apache.ratis.thirdparty.io.opencensus.stats.ViewManager;
import org.apache.ratis.thirdparty.io.opencensus.tags.TagContext;

final class NoopStats {
    private NoopStats() {
    }

    static StatsComponent newNoopStatsComponent() {
        return new NoopStatsComponent();
    }

    static StatsRecorder getNoopStatsRecorder() {
        return NoopStatsRecorder.INSTANCE;
    }

    static MeasureMap newNoopMeasureMap() {
        return new NoopMeasureMap();
    }

    static ViewManager newNoopViewManager() {
        return new NoopViewManager();
    }

    @ThreadSafe
    private static final class NoopViewManager
    extends ViewManager {
        private static final Timestamp ZERO_TIMESTAMP = Timestamp.create(0L, 0);
        @GuardedBy(value="registeredViews")
        private final Map<View.Name, View> registeredViews = new HashMap<View.Name, View>();
        @Nullable
        private volatile Set<View> exportedViews;

        private NoopViewManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerView(View newView) {
            Utils.checkNotNull(newView, "newView");
            Map<View.Name, View> map = this.registeredViews;
            synchronized (map) {
                this.exportedViews = null;
                View existing = this.registeredViews.get(newView.getName());
                Utils.checkArgument(existing == null || newView.equals(existing), "A different view with the same name already exists.");
                if (existing == null) {
                    this.registeredViews.put(newView.getName(), newView);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public ViewData getView(View.Name name) {
            Utils.checkNotNull(name, "name");
            Map<View.Name, View> map = this.registeredViews;
            synchronized (map) {
                View view = this.registeredViews.get(name);
                if (view == null) {
                    return null;
                }
                return ViewData.create(view, Collections.emptyMap(), view.getWindow().match(Functions.returnConstant(ViewData.AggregationWindowData.CumulativeData.create(ZERO_TIMESTAMP, ZERO_TIMESTAMP)), Functions.returnConstant(ViewData.AggregationWindowData.IntervalData.create(ZERO_TIMESTAMP)), Functions.throwAssertionError()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<View> getAllExportedViews() {
            Set<View> views = this.exportedViews;
            if (views == null) {
                Map<View.Name, View> map = this.registeredViews;
                synchronized (map) {
                    this.exportedViews = views = NoopViewManager.filterExportedViews(this.registeredViews.values());
                }
            }
            return views;
        }

        private static Set<View> filterExportedViews(Collection<View> allViews) {
            HashSet<View> views = new HashSet<View>();
            for (View view : allViews) {
                if (view.getWindow() instanceof View.AggregationWindow.Interval) continue;
                views.add(view);
            }
            return Collections.unmodifiableSet(views);
        }
    }

    private static final class NoopMeasureMap
    extends MeasureMap {
        private static final Logger logger = Logger.getLogger(NoopMeasureMap.class.getName());
        private boolean hasUnsupportedValues;

        private NoopMeasureMap() {
        }

        @Override
        public MeasureMap put(Measure.MeasureDouble measure, double value) {
            if (value < 0.0) {
                this.hasUnsupportedValues = true;
            }
            return this;
        }

        @Override
        public MeasureMap put(Measure.MeasureLong measure, long value) {
            if (value < 0L) {
                this.hasUnsupportedValues = true;
            }
            return this;
        }

        @Override
        public void record() {
        }

        @Override
        public void record(TagContext tags) {
            Utils.checkNotNull(tags, "tags");
            if (this.hasUnsupportedValues) {
                logger.log(Level.WARNING, "Dropping values, value to record must be non-negative.");
            }
        }
    }

    @Immutable
    private static final class NoopStatsRecorder
    extends StatsRecorder {
        static final StatsRecorder INSTANCE = new NoopStatsRecorder();

        private NoopStatsRecorder() {
        }

        @Override
        public MeasureMap newMeasureMap() {
            return NoopStats.newNoopMeasureMap();
        }
    }

    @ThreadSafe
    private static final class NoopStatsComponent
    extends StatsComponent {
        private final ViewManager viewManager = NoopStats.newNoopViewManager();
        private volatile boolean isRead;

        private NoopStatsComponent() {
        }

        @Override
        public ViewManager getViewManager() {
            return this.viewManager;
        }

        @Override
        public StatsRecorder getStatsRecorder() {
            return NoopStats.getNoopStatsRecorder();
        }

        @Override
        public StatsCollectionState getState() {
            this.isRead = true;
            return StatsCollectionState.DISABLED;
        }

        @Override
        @Deprecated
        public void setState(StatsCollectionState state) {
            Utils.checkNotNull(state, "state");
            Utils.checkState(!this.isRead, "State was already read, cannot set state.");
        }
    }
}

