/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import java.util.Objects;

public class BlobId {
    private final String id;

    public static BlobId fromBytes(byte[] bytes) {
        Preconditions.checkNotNull(bytes);
        return new BlobId(Hashing.sha256().hashBytes(bytes).toString());
    }

    public static BlobId fromString(String raw) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(raw));
        return new BlobId(raw);
    }

    private BlobId(String id) {
        this.id = id;
    }

    public String asString() {
        return this.id;
    }

    public final boolean equals(Object o) {
        if (o instanceof BlobId) {
            BlobId blobId = (BlobId)o;
            return Objects.equals(this.id, blobId.id);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).toString();
    }
}

