/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.james.util.Port;

public class Host {
    private final String hostName;
    private final int port;

    public static ImmutableList<Host> parseHosts(String hostsString) {
        return Host.parseHosts(hostsString, Optional.empty());
    }

    public static ImmutableList<Host> parseHosts(String hostsString, int defaultPort) {
        return Host.parseHosts(hostsString, Optional.of(defaultPort));
    }

    private static ImmutableList<Host> parseHosts(String hostsString, Optional<Integer> defaultPort) {
        return Splitter.on(',').omitEmptyStrings().splitToList(hostsString).stream().map(string -> Host.parse(string, defaultPort)).distinct().collect(Guavate.toImmutableList());
    }

    public static Host from(String hostname, int port) {
        return new Host(hostname, port);
    }

    public static Host parseConfString(String ipAndPort, int defaultPort) {
        return Host.parse(ipAndPort, Optional.of(defaultPort));
    }

    public static Host parseConfString(String ipAndPort) {
        return Host.parse(ipAndPort, Optional.empty());
    }

    public static Host parse(String ipAndPort, Optional<Integer> defaultPort) {
        Preconditions.checkNotNull(ipAndPort);
        Preconditions.checkArgument(!ipAndPort.isEmpty());
        List<String> parts = Host.retrieveHostParts(ipAndPort);
        String ip = parts.get(0);
        int port = Host.getPortFromConfPart(parts, defaultPort);
        return new Host(ip, port);
    }

    private static List<String> retrieveHostParts(String ipAndPort) {
        List<String> parts = Splitter.on(':').trimResults().splitToList(ipAndPort);
        if (parts.size() < 1 || parts.size() > 2) {
            throw new IllegalArgumentException(ipAndPort + " is not a valid cassandra node");
        }
        return parts;
    }

    private static int getPortFromConfPart(List<String> parts, Optional<Integer> defaultPort) {
        if (parts.size() == 2) {
            return Integer.parseInt(parts.get(1));
        }
        if (parts.size() == 1) {
            return defaultPort.orElseThrow(() -> new IllegalArgumentException("Host do not have port part but no default port provided"));
        }
        throw new RuntimeException("A host should be either a hostname or a hostname and a port separated by a ':'");
    }

    @VisibleForTesting
    Host(String hostName, int port) {
        Preconditions.checkNotNull(hostName, "Hostname could not be null");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(hostName), "Hostname could not be empty");
        Port.assertValid(port);
        this.hostName = hostName;
        this.port = port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public final int hashCode() {
        return Objects.hashCode(this.hostName, this.port);
    }

    public final boolean equals(Object object) {
        if (object instanceof Host) {
            Host that = (Host)object;
            return Objects.equal(this.hostName, that.hostName) && Objects.equal(this.port, that.port);
        }
        return false;
    }

    public String asString() {
        return this.hostName + ":" + this.port;
    }

    public String toString() {
        return this.asString();
    }
}

