/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.util.Util;

public class RequestTable<T> {
    protected T[] buffer;
    protected long low;
    protected long high;
    protected int removes_till_compaction;
    protected int num_removes;
    protected final Lock lock = new ReentrantLock();

    public RequestTable(int capacity) {
        this(capacity, 0L, 0L);
    }

    public RequestTable(int capacity, long low, long high) {
        int len = Util.getNextHigherPowerOfTwo(capacity);
        this.buffer = new Object[len];
        this.low = low;
        this.high = high;
    }

    public long low() {
        return this.low;
    }

    public long high() {
        return this.high;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int index(long seqno) {
        return (int)(seqno & (long)(this.capacity() - 1));
    }

    public int removesTillCompaction() {
        return this.removes_till_compaction;
    }

    public RequestTable<T> removesTillCompaction(int rems) {
        this.removes_till_compaction = rems;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(T element) {
        this.lock.lock();
        try {
            long next = this.high + 1L;
            if (next - this.low > (long)this.capacity()) {
                this._grow(next - this.low);
            }
            int high_index = this.index(this.high);
            this.buffer[high_index] = element;
            long l = this.high++;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long seqno) {
        this.lock.lock();
        try {
            int index = this.index(seqno);
            T t = this.buffer[index];
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(long seqno) {
        this.lock.lock();
        try {
            if (seqno < this.low || seqno > this.high) {
                T t = null;
                return t;
            }
            int index = this.index(seqno);
            T retval = this.buffer[index];
            if (retval != null && this.removes_till_compaction > 0) {
                ++this.num_removes;
            }
            this.buffer[index] = null;
            if (seqno == this.low) {
                this.advanceLow();
            }
            if (this.removes_till_compaction > 0 && this.num_removes >= this.removes_till_compaction) {
                this._compact();
                this.num_removes = 0;
            }
            T t = retval;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RequestTable<T> clear() {
        return this.clear(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestTable<T> clear(long mark) {
        this.lock.lock();
        try {
            this.low = this.high = mark;
            this.buffer = new Object[2];
            RequestTable requestTable = this;
            return requestTable;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestTable<T> forEach(Visitor<T> visitor) {
        if (visitor == null) {
            return null;
        }
        this.lock.lock();
        try {
            int index;
            T el;
            long i = this.low;
            for (long num_iterations = 0L; i < this.high && num_iterations < (long)this.buffer.length && visitor.visit(el = this.buffer[index = this.index(i)]); ++i, ++num_iterations) {
            }
            RequestTable requestTable = this;
            return requestTable;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestTable<T> forEachNonBlocking(Visitor<T> visitor) {
        int index;
        T el;
        long hi;
        long lo;
        T[] buf;
        if (visitor == null) {
            return null;
        }
        this.lock.lock();
        try {
            buf = this.buffer;
            lo = this.low;
            hi = this.high;
        }
        finally {
            this.lock.unlock();
        }
        long i = lo;
        for (long num_iterations = 0L; i < hi && num_iterations < (long)buf.length && visitor.visit(el = buf[index = this.index(i)]); ++i, ++num_iterations) {
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestTable<T> grow(int new_capacity) {
        this.lock.lock();
        try {
            this._grow(new_capacity);
            RequestTable requestTable = this;
            return requestTable;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compact() {
        this.lock.lock();
        try {
            boolean bl = this._compact();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contiguousSpaceAvailable() {
        this.lock.lock();
        try {
            boolean bl = this._contiguousSpaceAvailable(this.buffer.length >> 1);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        int retval = 0;
        long i = this.low;
        for (long num_iterations = 0L; i < this.high && num_iterations < (long)this.buffer.length; ++i, ++num_iterations) {
            int index = this.index(i);
            if (this.buffer[index] == null) continue;
            ++retval;
        }
        return retval;
    }

    public String toString() {
        return String.format("low=%d high=%d cap=%d, %d element(s)", this.low, this.high, this.buffer.length, this.size());
    }

    protected void _grow(long new_capacity) {
        int new_cap = Util.getNextHigherPowerOfTwo((int)Math.max((long)this.buffer.length, new_capacity));
        if (new_cap == this.buffer.length) {
            return;
        }
        this._copy(new_cap);
    }

    protected boolean _compact() {
        boolean compactable;
        int new_cap = this.buffer.length >> 1;
        boolean bl = compactable = this.buffer.length > 0 && this.high - this.low <= (long)new_cap;
        if (!compactable) {
            return false;
        }
        this._copy(new_cap);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpContents() {
        StringBuilder sb = new StringBuilder();
        this.lock.lock();
        try {
            int new_cap = this.buffer.length >> 1;
            long i = this.low;
            for (long num_iterations = 0L; i < this.high && num_iterations < (long)this.buffer.length; ++i, ++num_iterations) {
                int index = this.index(i);
                T el = this.buffer[index];
                if (el == null) continue;
                long hash = el.hashCode();
                int small_idx = RequestTable.index(i, new_cap);
                sb.append(String.format("seqno %d: index: %d val: %d, index in %d-buffer: %d\n", i, index, hash, new_cap, small_idx));
            }
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }

    protected void _copy(int new_cap) {
        Object[] new_buf = new Object[new_cap];
        int new_len = new_buf.length;
        int old_len = this.buffer.length;
        long i = this.low;
        for (long num_iterations = 0L; i < this.high && num_iterations < (long)old_len; ++i, ++num_iterations) {
            int old_index = RequestTable.index(i, old_len);
            if (this.buffer[old_index] == null) continue;
            int new_index = RequestTable.index(i, new_len);
            new_buf[new_index] = this.buffer[old_index];
        }
        this.buffer = new_buf;
    }

    protected boolean _contiguousSpaceAvailable(int space_needed) {
        int num_slots_scanned = 0;
        int size_of_contiguous_area = 0;
        if (this.high - this.low - 1L < (long)space_needed) {
            return false;
        }
        for (long i = this.low + 1L; i < this.high; ++i) {
            ++num_slots_scanned;
            int index = this.index(i);
            if (this.buffer[index] == null) {
                if (++size_of_contiguous_area < space_needed) continue;
                return true;
            }
            size_of_contiguous_area = 0;
            if (num_slots_scanned <= space_needed && this.high - i - 1L >= (long)space_needed) continue;
            return false;
        }
        return false;
    }

    protected int highestContiguousSpaceAvailable() {
        int size_of_current_contiguous_area = 0;
        int highest = 0;
        for (long i = this.low + 1L; i < this.high; ++i) {
            int index = this.index(i);
            if (this.buffer[index] == null) {
                ++size_of_current_contiguous_area;
                continue;
            }
            highest = Math.max(highest, size_of_current_contiguous_area);
            size_of_current_contiguous_area = 0;
        }
        return Math.max(highest, size_of_current_contiguous_area);
    }

    protected void advanceLow() {
        int index;
        while (this.low < this.high && this.buffer[index = this.index(this.low)] == null) {
            ++this.low;
        }
    }

    protected static int index(long seqno, int length) {
        return (int)(seqno & (long)(length - 1));
    }

    public static interface Visitor<T> {
        public boolean visit(T var1);
    }
}

