/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.InvalidPublicKeyException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Jwk {
    private static final String ALGORITHM_RSA = "RSA";
    private static final String ALGORITHM_ELLIPTIC_CURVE = "EC";
    private static final String ELLIPTIC_CURVE_TYPE_P256 = "P-256";
    private static final String ELLIPTIC_CURVE_TYPE_P384 = "P-384";
    private static final String ELLIPTIC_CURVE_TYPE_P521 = "P-521";
    private final String id;
    private final String type;
    private final String algorithm;
    private final String usage;
    private final List<String> operations;
    private final String certificateUrl;
    private final List<String> certificateChain;
    private final String certificateThumbprint;
    private final Map<String, Object> additionalAttributes;

    public Jwk(String id, String type, String algorithm, String usage, List<String> operations, String certificateUrl, List<String> certificateChain, String certificateThumbprint, Map<String, Object> additionalAttributes) {
        this.id = id;
        this.type = type;
        this.algorithm = algorithm;
        this.usage = usage;
        this.operations = operations;
        this.certificateUrl = certificateUrl;
        this.certificateChain = certificateChain;
        this.certificateThumbprint = certificateThumbprint;
        this.additionalAttributes = additionalAttributes;
    }

    @Deprecated
    public Jwk(String id, String type, String algorithm, String usage, String operations, String certificateUrl, List<String> certificateChain, String certificateThumbprint, Map<String, Object> additionalAttributes) {
        this(id, type, algorithm, usage, Collections.singletonList(operations), certificateUrl, certificateChain, certificateThumbprint, additionalAttributes);
    }

    public static Jwk fromValues(Map<String, Object> map) {
        HashMap<String, Object> values = new HashMap<String, Object>(map);
        String kid = (String)values.remove("kid");
        String kty = (String)values.remove("kty");
        String alg = (String)values.remove("alg");
        String use = (String)values.remove("use");
        Object keyOps = values.remove("key_ops");
        String x5u = (String)values.remove("x5u");
        List x5c = (List)values.remove("x5c");
        String x5t = (String)values.remove("x5t");
        if (kty == null) {
            throw new IllegalArgumentException("Attributes " + map + " are not from a valid jwk");
        }
        if (keyOps instanceof String) {
            return new Jwk(kid, kty, alg, use, (String)keyOps, x5u, (List<String>)x5c, x5t, values);
        }
        return new Jwk(kid, kty, alg, use, (List)keyOps, x5u, (List<String>)x5c, x5t, values);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getOperations() {
        if (this.operations == null || this.operations.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String delimiter = ",";
        for (String operation : this.operations) {
            sb.append(operation);
            sb.append(delimiter);
        }
        String ops = sb.toString();
        return ops.substring(0, ops.length() - delimiter.length());
    }

    public List<String> getOperationsAsList() {
        return this.operations;
    }

    public String getCertificateUrl() {
        return this.certificateUrl;
    }

    public List<String> getCertificateChain() {
        return this.certificateChain;
    }

    public String getCertificateThumbprint() {
        return this.certificateThumbprint;
    }

    public Map<String, Object> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public PublicKey getPublicKey() throws InvalidPublicKeyException {
        PublicKey publicKey = null;
        switch (this.type) {
            case "RSA": {
                try {
                    KeyFactory kf = KeyFactory.getInstance(ALGORITHM_RSA);
                    BigInteger modulus = new BigInteger(1, Base64.getUrlDecoder().decode(this.stringValue("n")));
                    BigInteger exponent = new BigInteger(1, Base64.getUrlDecoder().decode(this.stringValue("e")));
                    publicKey = kf.generatePublic(new RSAPublicKeySpec(modulus, exponent));
                    break;
                }
                catch (InvalidKeySpecException e) {
                    throw new InvalidPublicKeyException("Invalid public key", e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new InvalidPublicKeyException("Invalid algorithm to generate key", e);
                }
            }
            case "EC": {
                try {
                    String curve;
                    KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_ELLIPTIC_CURVE);
                    ECPoint ecPoint = new ECPoint(new BigInteger(Base64.getUrlDecoder().decode(this.stringValue("x"))), new BigInteger(Base64.getUrlDecoder().decode(this.stringValue("y"))));
                    AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(ALGORITHM_ELLIPTIC_CURVE);
                    switch (curve = this.stringValue("crv")) {
                        case "P-256": {
                            algorithmParameters.init(new ECGenParameterSpec("secp256r1"));
                            break;
                        }
                        case "P-384": {
                            algorithmParameters.init(new ECGenParameterSpec("secp384r1"));
                            break;
                        }
                        case "P-521": {
                            algorithmParameters.init(new ECGenParameterSpec("secp521r1"));
                            break;
                        }
                        default: {
                            throw new InvalidPublicKeyException("Invalid or unsupported curve type " + curve);
                        }
                    }
                    ECParameterSpec ecParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
                    ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
                    publicKey = keyFactory.generatePublic(ecPublicKeySpec);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new InvalidPublicKeyException("Invalid algorithm to generate key", e);
                }
                catch (InvalidKeySpecException | InvalidParameterSpecException e) {
                    throw new InvalidPublicKeyException("Invalid public key", e);
                }
            }
            default: {
                throw new InvalidPublicKeyException("The key type of " + this.type + " is not supported");
            }
        }
        return publicKey;
    }

    private String stringValue(String key) {
        return (String)this.additionalAttributes.get(key);
    }

    public String toString() {
        return "Jwk{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", algorithm='" + this.algorithm + '\'' + ", usage='" + this.usage + '\'' + ", additionalAttributes=" + this.additionalAttributes + '}';
    }
}

