/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BaseAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class AggregationBuilder
implements NamedWriteable,
ToXContentFragment,
BaseAggregationBuilder,
Rewriteable<AggregationBuilder> {
    protected final String name;
    protected AggregatorFactories.Builder factoriesBuilder = AggregatorFactories.builder();

    protected AggregationBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("[name] must not be null: [" + name + "]");
        }
        this.name = name;
    }

    protected AggregationBuilder(AggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder) {
        this.name = clone.name;
        this.factoriesBuilder = factoriesBuilder;
    }

    public String getName() {
        return this.name;
    }

    protected abstract AggregatorFactory build(QueryShardContext var1, AggregatorFactory var2) throws IOException;

    @Override
    public abstract AggregationBuilder setMetadata(Map<String, Object> var1);

    public abstract Map<String, Object> getMetadata();

    public abstract AggregationBuilder subAggregation(AggregationBuilder var1);

    public abstract AggregationBuilder subAggregation(PipelineAggregationBuilder var1);

    public Collection<AggregationBuilder> getSubAggregations() {
        return this.factoriesBuilder.getAggregatorFactories();
    }

    public Collection<PipelineAggregationBuilder> getPipelineAggregations() {
        return this.factoriesBuilder.getPipelineAggregatorFactories();
    }

    @Override
    public abstract AggregationBuilder subAggregations(AggregatorFactories.Builder var1);

    protected abstract AggregationBuilder shallowCopy(AggregatorFactories.Builder var1, Map<String, Object> var2);

    @Override
    public final AggregationBuilder rewrite(QueryRewriteContext context) throws IOException {
        AggregationBuilder rewritten = this.doRewrite(context);
        AggregatorFactories.Builder rewrittenSubAggs = this.factoriesBuilder.rewrite(context);
        if (rewritten != this) {
            return ((AggregationBuilder)rewritten.setMetadata((Map)this.getMetadata())).subAggregations(rewrittenSubAggs);
        }
        if (rewrittenSubAggs != this.factoriesBuilder) {
            return this.shallowCopy(rewrittenSubAggs, this.getMetadata());
        }
        return this;
    }

    protected AggregationBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        return this;
    }

    public PipelineAggregator.PipelineTree buildPipelineTree() {
        return this.factoriesBuilder.buildPipelineTree();
    }

    public abstract BucketCardinality bucketCardinality();

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static final class CommonFields
    extends ParseField.CommonFields {
        public static final ParseField VALUE_TYPE = new ParseField("value_type", new String[0]);
    }

    public static enum BucketCardinality {
        NONE,
        ONE,
        MANY;

    }
}

