/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.modules;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.CreateType;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.TableOptions;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface CassandraMessageModule {
    public static final int CACHED_MESSAGE_ID_ROWS = 1000;
    public static final int CACHED_IMAP_UID_ROWS = 100;
    public static final CassandraModule MODULE = CassandraModule.builder().table("messageIdTable").comment("Holds mailbox and flags for each message, lookup by mailbox ID + UID").options(options -> (Create.Options)((Create.Options)options.compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.sizedTieredStategy())).caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)1000))).statement(statement -> (Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)statement.addPartitionKey("mailboxId", DataType.timeuuid()).addClusteringColumn("uid", DataType.bigint()).addColumn("messageId", DataType.timeuuid())).addColumn("threadId", DataType.timeuuid())).addColumn("modSeq", DataType.bigint())).addColumn("flagAnswered", DataType.cboolean())).addColumn("flagDeleted", DataType.cboolean())).addColumn("flagDraft", DataType.cboolean())).addColumn("flagFlagged", DataType.cboolean())).addColumn("flagRecent", DataType.cboolean())).addColumn("flagSeen", DataType.cboolean())).addColumn("flagUser", DataType.cboolean())).addColumn("userFlags", (DataType)DataType.set((DataType)DataType.text()))).addColumn("internalDate", DataType.timestamp())).addColumn("bodyStartOctet", DataType.cint())).addColumn("fullContentOctets", DataType.bigint())).addColumn("headerContent", DataType.text())).table("imapUidTable").comment("Holds mailbox and flags for each message, lookup by message ID").options(options -> (Create.Options)((Create.Options)((Create.Options)options.compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.sizedTieredStategy())).compressionOptions(SchemaBuilder.lz4().withChunkLengthInKb(Integer.valueOf(8)))).caching(SchemaBuilder.KeyCaching.ALL, SchemaBuilder.rows((int)100))).statement(statement -> (Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)statement.addPartitionKey("messageId", DataType.timeuuid()).addClusteringColumn("mailboxId", DataType.timeuuid()).addClusteringColumn("uid", DataType.bigint()).addColumn("threadId", DataType.timeuuid())).addColumn("modSeq", DataType.bigint())).addColumn("flagAnswered", DataType.cboolean())).addColumn("flagDeleted", DataType.cboolean())).addColumn("flagDraft", DataType.cboolean())).addColumn("flagFlagged", DataType.cboolean())).addColumn("flagRecent", DataType.cboolean())).addColumn("flagSeen", DataType.cboolean())).addColumn("flagUser", DataType.cboolean())).addColumn("userFlags", (DataType)DataType.set((DataType)DataType.text()))).addColumn("internalDate", DataType.timestamp())).addColumn("bodyStartOctet", DataType.cint())).addColumn("fullContentOctets", DataType.bigint())).addColumn("headerContent", DataType.text())).table("messageV2").comment("Holds message metadata, independently of any mailboxes. Content of messages is stored in `blobs` and `blobparts` tables.").statement(statement -> (Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)statement.addPartitionKey("messageId", DataType.timeuuid()).addColumn("internalDate", DataType.timestamp())).addColumn("bodyStartOctet", DataType.cint())).addColumn("bodyOctets", DataType.bigint())).addColumn("textualLineCount", DataType.bigint())).addColumn("fullContentOctets", DataType.bigint())).addColumn("bodyContent", DataType.text())).addColumn("headerContent", DataType.text())).addUDTListColumn("attachments", SchemaBuilder.frozen((String)"attachments"))).addUDTListColumn("properties", SchemaBuilder.frozen((String)"properties"))).table("messageV3").comment("Holds message metadata, independently of any mailboxes. Content of messages is stored in `blobs` and `blobparts` tables. Optimizes property storage compared to V2.").statement(statement -> (Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)statement.addPartitionKey("messageId", DataType.timeuuid()).addColumn("internalDate", DataType.timestamp())).addColumn("bodyStartOctet", DataType.cint())).addColumn("bodyOctets", DataType.bigint())).addColumn("textualLineCount", DataType.bigint())).addColumn("fullContentOctets", DataType.bigint())).addColumn("bodyContent", DataType.text())).addColumn("headerContent", DataType.text())).addColumn("contentDescription", DataType.text())).addColumn("contentDispositionType", DataType.text())).addColumn("mediaType", DataType.text())).addColumn("subType", DataType.text())).addColumn("contentId", DataType.text())).addColumn("contentMd5", DataType.text())).addColumn("contentTransferEncoding", DataType.text())).addColumn("contentLocation", DataType.text())).addColumn("contentLanguage", (DataType)DataType.frozenList((DataType)DataType.text()))).addColumn("contentDispositionParameters", (DataType)DataType.frozenMap((DataType)DataType.text(), (DataType)DataType.text()))).addColumn("contentTypeParameters", (DataType)DataType.frozenMap((DataType)DataType.text(), (DataType)DataType.text()))).addUDTListColumn("attachments", SchemaBuilder.frozen((String)"attachments"))).type("properties").statement(statement -> (CreateType)((CreateType)((CreateType)statement.addColumn("namespace", DataType.text())).addColumn("name", DataType.text())).addColumn("value", DataType.text())).type("attachments").statement(statement -> (CreateType)((CreateType)((CreateType)((CreateType)statement.addColumn("id", DataType.text())).addColumn("name", DataType.text())).addColumn("cid", DataType.text())).addColumn("isInline", DataType.cboolean())).build();
}

