/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.util.Optional;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;

public class ParsedAttachment {
    private final ContentType contentType;
    private final ByteSource content;
    private final Optional<String> name;
    private final Optional<Cid> cid;
    private final boolean isInline;

    public static Builder.RequireContentType builder() {
        return contentType -> content -> name -> cid -> isInline -> new ParsedAttachment(contentType, content, name, cid, isInline);
    }

    private ParsedAttachment(ContentType contentType, ByteSource content, Optional<String> name, Optional<Cid> cid, boolean isInline) {
        this.contentType = contentType;
        this.content = content;
        this.name = name;
        this.cid = cid;
        this.isInline = isInline;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public ByteSource getContent() {
        return this.content;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<Cid> getCid() {
        return this.cid;
    }

    public boolean isInline() {
        return this.isInline;
    }

    public MessageAttachmentMetadata asMessageAttachment(AttachmentId attachmentId, long size, MessageId messageId) {
        return MessageAttachmentMetadata.builder().attachment(AttachmentMetadata.builder().attachmentId(attachmentId).type(this.contentType).messageId(messageId).size(size).build()).name(this.name).cid(this.cid).isInline(this.isInline).build();
    }

    public MessageAttachmentMetadata asMessageAttachment(AttachmentId attachmentId, MessageId messageId) throws IOException {
        return MessageAttachmentMetadata.builder().attachment(AttachmentMetadata.builder().attachmentId(attachmentId).type(this.contentType).size(this.content.size()).messageId(messageId).build()).name(this.name).cid(this.cid).isInline(this.isInline).build();
    }

    static interface Builder {

        @FunctionalInterface
        public static interface RequireIsInline {
            public ParsedAttachment inline(boolean var1);

            default public ParsedAttachment inline() {
                return this.inline(true);
            }
        }

        @FunctionalInterface
        public static interface RequireCid {
            public RequireIsInline cid(Optional<Cid> var1);

            default public RequireIsInline cid(Cid cid) {
                return this.cid(Optional.of(cid));
            }

            default public RequireIsInline noCid() {
                return this.cid(Optional.empty());
            }
        }

        @FunctionalInterface
        public static interface RequireName {
            public RequireCid name(Optional<String> var1);

            default public RequireCid name(String name) {
                return this.name(Optional.of(name));
            }

            default public RequireCid noName() {
                return this.name(Optional.empty());
            }
        }

        @FunctionalInterface
        public static interface RequireContent {
            public RequireName content(ByteSource var1);
        }

        @FunctionalInterface
        public static interface RequireContentType {
            public RequireContent contentType(ContentType var1);

            default public RequireContent contentType(String contentType) {
                return this.contentType(ContentType.of(contentType));
            }
        }
    }
}

